/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import sim.display.Console;
import sim.display.GUIState;
import sim.engine.Schedule;
import sim.engine.Stoppable;
import sim.portrayal.Inspector;
import sim.util.Bag;
import sim.util.Properties;
import sim.util.gui.Utilities;

public abstract class PropertyInspector
extends Inspector {
    public int index;
    public Properties properties;
    public GUIState simulation;
    static Bag classes = null;
    boolean validInspector = false;
    protected Stoppable stopper;

    public void setStopper(Stoppable stopper) {
        this.stopper = stopper;
    }

    public Stoppable getStopper() {
        return this.stopper;
    }

    protected void setValidInspector(boolean val) {
        this.validInspector = val;
    }

    public boolean isValidInspector() {
        return this.validInspector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyInspector makeInspector(Class inspectorClass, Properties properties, int index, Frame parent, GUIState simulation) {
        Schedule schedule = simulation.state.schedule;
        synchronized (schedule) {
            try {
                PropertyInspector inspector = (PropertyInspector)inspectorClass.getConstructor(Properties.class, Integer.TYPE, Frame.class, GUIState.class).newInstance(properties, new Integer(index), parent, simulation);
                if (inspector.isValidInspector()) {
                    return inspector;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static String name() {
        return "Name Not Set";
    }

    public static Class[] types() {
        return new Class[0];
    }

    public PropertyInspector(Properties properties, int index, Frame parent, GUIState simulation) {
        this.properties = properties;
        this.index = index;
        this.simulation = simulation;
    }

    public static String getMenuNameForPropertyInspectorClass(String classname) {
        try {
            return (String)Class.forName(classname).getMethod("name", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    static boolean typesForClassCompatable(String classname, Class type) {
        try {
            Class[] types = (Class[])Class.forName(classname).getMethod("types", new Class[0]).invoke(null, new Object[0]);
            if (types == null) {
                return true;
            }
            for (int x = 0; x < types.length; ++x) {
                if (!types[x].isAssignableFrom(type)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static Bag getPropertyInspectorClassNames() {
        if (classes == null) {
            classes = new Bag();
            try {
                InputStream s = PropertyInspector.class.getResourceAsStream("propertyinspector.classes");
                StreamTokenizer st = new StreamTokenizer(new BufferedReader(new InputStreamReader(s)));
                st.resetSyntax();
                st.wordChars(33, 255);
                st.commentChar(35);
                st.whitespaceChars(0, 32);
                while (st.nextToken() != -1) {
                    if (st.sval == null) continue;
                    classes.add(st.sval);
                }
                s.close();
            }
            catch (Throwable e) {
                System.err.println("WARNING: Couldn't load the Propertyinspector.classes file because of error. \nLikely the file does not exist or could not be opened.\nThe error was:\n");
                e.printStackTrace();
            }
        }
        return classes;
    }

    public static JToggleButton getPopupMenu(final Properties properties, final int index, final GUIState state, JPopupMenu pop) {
        boolean somethingCompatable = false;
        final Bag classes = PropertyInspector.getPropertyInspectorClassNames();
        if (pop == null) {
            pop = new JPopupMenu();
        }
        final JPopupMenu popup = pop;
        popup.setLightWeightPopupEnabled(false);
        final JToggleButton toggleButton = new JToggleButton(INSPECT_ICON);
        toggleButton.setPressedIcon(INSPECT_ICON_P);
        toggleButton.setBorderPainted(false);
        toggleButton.setContentAreaFilled(false);
        toggleButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        toggleButton.setToolTipText("Show Additional Per-Property Inspectors");
        toggleButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                popup.show(e.getComponent(), 0, toggleButton.getSize().height);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                toggleButton.setSelected(false);
            }
        });
        int x = 0;
        while (x < classes.numObjs) {
            JMenuItem menu = new JMenuItem(PropertyInspector.getMenuNameForPropertyInspectorClass((String)classes.objs[x]));
            popup.add(menu);
            if (!PropertyInspector.typesForClassCompatable((String)classes.objs[x], properties.getType(index))) {
                menu.setEnabled(false);
            } else {
                somethingCompatable = true;
            }
            final int menuIndex = x++;
            menu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Inspector inspector = null;
                    try {
                        inspector = PropertyInspector.makeInspector(Class.forName((String)classes.objs[menuIndex]), properties, index, (Console)state.controller, state);
                    }
                    catch (ClassNotFoundException error) {
                        // empty catch block
                    }
                    if (inspector != null) {
                        try {
                            ((PropertyInspector)inspector).setStopper(inspector.reviseStopper(state.scheduleRepeatingImmediatelyAfter(inspector.getUpdateSteppable())));
                        }
                        catch (IllegalArgumentException ex) {
                            Utilities.inform("The simulation is over and the item will not be tracked further.", "If you wanted to track, restart the simulation in paused state, then try tracking the item again.", null);
                            ((PropertyInspector)inspector).setStopper(inspector.reviseStopper(new Stoppable(){

                                @Override
                                public void stop() {
                                }
                            }));
                        }
                        state.controller.registerInspector(inspector, ((PropertyInspector)inspector).getStopper());
                        if (((PropertyInspector)inspector).shouldCreateFrame()) {
                            JFrame frame = ((PropertyInspector)inspector).createFrame(((PropertyInspector)inspector).getStopper());
                            frame.setVisible(true);
                        }
                        inspector.updateInspector();
                    }
                }
            });
        }
        if (!somethingCompatable) {
            return null;
        }
        return toggleButton;
    }

    @Override
    public JFrame createFrame(Stoppable stopper) {
        JFrame frame = super.createFrame(stopper);
        frame.setTitle("" + this.properties.getName(this.index) + " of " + this.properties.getObject());
        return frame;
    }

    public boolean shouldCreateFrame() {
        return true;
    }
}

