/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sim.portrayal.Inspector;

public class TabbedInspector
extends Inspector {
    public ArrayList inspectors = new ArrayList();
    public JTabbedPane tabs = new JTabbedPane();
    boolean updatingAllInspectors;

    public TabbedInspector() {
        this(true);
    }

    public TabbedInspector(boolean isVolatile) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedInspector.this.updateDisplayedInspector();
            }
        });
        this.setVolatile(isVolatile);
    }

    void updateDisplayedInspector() {
        if (this.tabs.getTabCount() > 0) {
            Inspector i = (Inspector)this.inspectors.get(this.tabs.getSelectedIndex());
            i.updateInspector();
            i.repaint();
        }
    }

    public void setUpdatingAllInspectors(boolean val) {
        this.updatingAllInspectors = true;
    }

    public boolean isUpdatingAllInspectors() {
        return this.updatingAllInspectors;
    }

    @Override
    public void setVolatile(boolean val) {
        int len = this.inspectors.size();
        for (int x = 0; x < len; ++x) {
            ((Inspector)this.inspectors.get(x)).setVolatile(val);
        }
        super.setVolatile(val);
    }

    @Override
    public void updateInspector() {
        int len = this.inspectors.size();
        if (this.updatingAllInspectors) {
            for (int x = 0; x < len; ++x) {
                ((Inspector)this.inspectors.get(x)).updateInspector();
            }
        } else {
            this.updateDisplayedInspector();
        }
    }

    public void addInspector(Inspector i, String tab) {
        i.setTitle(tab);
        this.inspectors.add(i);
        this.tabs.addTab(tab, i);
        i.setVolatile(this.isVolatile());
    }

    public void addInspector(Inspector i) {
        this.inspectors.add(i);
        this.tabs.addTab(i.getTitle(), i);
        i.setVolatile(this.isVolatile());
    }

    public Inspector removeInspector(Inspector i) {
        int len = this.inspectors.size();
        int x = 0;
        for (x = 0; x < len && this.inspectors.get(x) != i; ++x) {
        }
        if (x == len) {
            return null;
        }
        this.tabs.removeTabAt(x);
        return (Inspector)this.inspectors.remove(x);
    }

    public void clear() {
        this.tabs.removeAll();
        this.inspectors.clear();
    }
}

