/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.network;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import sim.field.SparseField2D;
import sim.field.continuous.Continuous2D;
import sim.field.network.Edge;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.network.EdgeDrawInfo2D;
import sim.portrayal.network.SimpleEdgePortrayal2D;
import sim.portrayal.network.SpatialNetwork2D;
import sim.util.Bag;
import sim.util.Double2D;

public class NetworkPortrayal2D
extends FieldPortrayal2D {
    SimpleEdgePortrayal2D defaultPortrayal = new SimpleEdgePortrayal2D();

    @Override
    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    @Override
    public void setField(Object field) {
        if (!(field instanceof SpatialNetwork2D)) {
            throw new RuntimeException("Invalid field for FieldPortrayal2D: " + field);
        }
        super.setField(field);
    }

    @Override
    protected void hitOrDraw(Graphics2D graphics, DrawInfo2D info, Bag putInHere) {
        SpatialNetwork2D field = (SpatialNetwork2D)this.field;
        if (field == null) {
            return;
        }
        SparseField2D otherField = field.field2;
        if (otherField == null) {
            otherField = field.field;
        }
        Double2D dimensions = field.getDimensions();
        double xScale = info.draw.width / dimensions.x;
        double yScale = info.draw.height / dimensions.y;
        EdgeDrawInfo2D newinfo = new EdgeDrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(0.0, 0.0, xScale, yScale), info.clip, new Point2D.Double(0.0, 0.0));
        newinfo.fieldPortrayal = this;
        newinfo.precise = info.precise;
        Bag nodes = field.network.getAllNodes();
        HashMap<Edge, Edge> edgemap = new HashMap<Edge, Edge>();
        for (int x = 0; x < nodes.numObjs; ++x) {
            Object node = nodes.objs[x];
            Bag edges = field.network.getEdgesOut(node);
            Double2D locStart = field.field.getObjectLocationAsDouble2D(node);
            if (locStart == null) continue;
            if (field.field instanceof Continuous2D) {
                newinfo.draw.x = info.draw.x + xScale * locStart.x;
                newinfo.draw.y = info.draw.y + yScale * locStart.y;
            } else {
                newinfo.draw.x = (int)Math.floor(info.draw.x + xScale * locStart.x);
                newinfo.draw.y = (int)Math.floor(info.draw.y + yScale * locStart.y);
                double width = (double)((int)Math.floor(info.draw.x + xScale * (locStart.x + 1.0))) - newinfo.draw.x;
                double height = (double)((int)Math.floor(info.draw.y + yScale * (locStart.y + 1.0))) - newinfo.draw.y;
                newinfo.draw.x += width / 2.0;
                newinfo.draw.y += height / 2.0;
            }
            for (int y = 0; y < edges.numObjs; ++y) {
                Edge edge = (Edge)edges.objs[y];
                Double2D locStop = otherField.getObjectLocationAsDouble2D(edge.getOtherNode(node));
                if (locStop == null) continue;
                if (!field.network.isDirected()) {
                    if (edgemap.containsKey(edge)) continue;
                    edgemap.put(edge, edge);
                }
                if (otherField instanceof Continuous2D) {
                    newinfo.secondPoint.x = info.draw.x + xScale * locStop.x;
                    newinfo.secondPoint.y = info.draw.y + yScale * locStop.y;
                } else {
                    newinfo.secondPoint.x = (int)Math.floor(info.draw.x + xScale * locStop.x);
                    newinfo.secondPoint.y = (int)Math.floor(info.draw.y + yScale * locStop.y);
                    double width = (double)((int)Math.floor(info.draw.x + xScale * (locStop.x + 1.0))) - newinfo.secondPoint.x;
                    double height = (double)((int)Math.floor(info.draw.y + yScale * (locStop.y + 1.0))) - newinfo.secondPoint.y;
                    newinfo.secondPoint.x += width / 2.0;
                    newinfo.secondPoint.y += height / 2.0;
                }
                Portrayal p = this.getPortrayalForObject(edge);
                if (!(p instanceof SimpleEdgePortrayal2D)) {
                    throw new RuntimeException("Unexpected Portrayal " + p + " for object " + edge + " -- expected a SimpleEdgePortrayal2D");
                }
                SimpleEdgePortrayal2D portrayal = (SimpleEdgePortrayal2D)p;
                newinfo.location = edge;
                if (graphics == null) {
                    if (!portrayal.hitObject(edge, newinfo)) continue;
                    putInHere.add(this.getWrapper(edge));
                    continue;
                }
                portrayal.draw(edge, graphics, newinfo);
            }
        }
    }

    String edgeLocation(Edge edge) {
        if (edge == null) {
            return "(Null)";
        }
        if (edge.owner() == null) {
            return "(Unowned)" + edge.from() + " --> " + edge.to();
        }
        if (edge.owner().isDirected()) {
            return edge.from() + " --> " + edge.to();
        }
        return edge.from() + " <-> " + edge.to();
    }

    public LocationWrapper getWrapper(Edge edge) {
        final SpatialNetwork2D field = (SpatialNetwork2D)this.field;
        return new LocationWrapper(edge.info, edge, this){

            @Override
            public String getLocationName() {
                Edge edge = (Edge)this.getLocation();
                if (field != null && field.network != null) {
                    Bag b = field.network.getEdgesOut(edge.from());
                    for (int x = 0; x < b.numObjs; ++x) {
                        if (b.objs[x] != edge) continue;
                        return NetworkPortrayal2D.this.edgeLocation(edge);
                    }
                }
                return "Gone.  Was: " + NetworkPortrayal2D.this.edgeLocation(edge);
            }
        };
    }
}

