/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import sim.display.GUIState;
import sim.display.Manipulating2D;
import sim.engine.Schedule;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Orientable2D;
import sim.portrayal.Oriented2D;
import sim.portrayal.Scalable2D;
import sim.portrayal.SimplePortrayal2D;

public class AdjustablePortrayal2D
extends SimplePortrayal2D {
    public static final double CIRCLE_RADIUS = 30.0;
    public static final double KNOB_RADIUS = 5.0;
    public static final double SLOP = 5.0;
    public static final Paint LOWER_PAINT = new Color(255, 255, 255, 200);
    public static final Stroke LOWER_STROKE = new BasicStroke(3.0f);
    public static final Paint UPPER_PAINT = new Color(0, 0, 0, 255);
    public static final Stroke UPPER_STROKE = new BasicStroke(1.0f);
    public static final Ellipse2D circle = new Ellipse2D.Double();
    public static final Ellipse2D knob = new Ellipse2D.Double();
    public SimplePortrayal2D child;
    boolean adjusting = false;
    Object adjustingObject = null;
    double adjustingInitialScale = 1.0;
    Point2D.Double adjustingInitialPosition = null;

    public AdjustablePortrayal2D(SimplePortrayal2D child) {
        this.child = child;
    }

    public SimplePortrayal2D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal2D)) {
            throw new RuntimeException("Object provided to AdjustablePortrayal2D is not a SimplePortrayal2D: " + object);
        }
        return (SimplePortrayal2D)object;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        SimplePortrayal2D child = this.getChild(object);
        child.draw(object, graphics, info);
        if (info.selected && object != null && (object instanceof Oriented2D || object instanceof Scalable2D)) {
            double orientation = 0.0;
            double scale = 1.0;
            if (object instanceof Oriented2D) {
                orientation = ((Oriented2D)object).orientation2D();
            }
            if (object instanceof Scalable2D) {
                scale = ((Scalable2D)object).getScale2D();
            }
            circle.setFrame(info.draw.x - 30.0, info.draw.y - 30.0, 60.0, 60.0);
            knob.setFrame(info.draw.x + 30.0 * Math.cos(orientation) - 5.0, info.draw.y + 30.0 * Math.sin(orientation) - 5.0, 10.0, 10.0);
            graphics.setPaint(LOWER_PAINT);
            graphics.setStroke(LOWER_STROKE);
            graphics.draw(circle);
            graphics.draw(knob);
            graphics.setPaint(UPPER_PAINT);
            graphics.setStroke(UPPER_STROKE);
            graphics.draw(circle);
            graphics.fill(knob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMouseEvent(GUIState guistate, Manipulating2D manipulating, LocationWrapper wrapper, MouseEvent event, DrawInfo2D range, int type) {
        Schedule schedule = guistate.state.schedule;
        synchronized (schedule) {
            Point2D.Double myPosition = ((FieldPortrayal2D)wrapper.getFieldPortrayal()).getObjectPosition(wrapper.getObject(), range);
            Object object = wrapper.getObject();
            if (!(myPosition == null || object == null || this.adjusting && this.adjustingObject != object || !(object instanceof Scalable2D) && !(object instanceof Orientable2D))) {
                double orientation = 0.0;
                if (object instanceof Oriented2D) {
                    orientation = ((Oriented2D)object).orientation2D();
                }
                double knobX = myPosition.getX() + 30.0 * Math.cos(orientation);
                double knobY = myPosition.getY() + 30.0 * Math.sin(orientation);
                int id = event.getID();
                if (id == 501) {
                    if (this.adjusting && object == this.adjustingObject) {
                        this.adjusting = false;
                        this.adjustingObject = null;
                    }
                    double dx = (double)event.getX() - myPosition.getX();
                    double dy = (double)event.getY() - myPosition.getY();
                    double distance = Math.sqrt(dx * dx + dy * dy);
                    if (object instanceof Scalable2D) {
                        this.adjustingInitialScale = ((Scalable2D)object).getScale2D();
                    }
                    if (Math.abs(distance - 30.0) <= 5.0) {
                        this.adjusting = true;
                        this.adjustingObject = object;
                        this.adjustingInitialPosition = myPosition;
                        return true;
                    }
                } else {
                    if (id == 506 && this.adjusting) {
                        double dx = (double)event.getX() - this.adjustingInitialPosition.getX();
                        double dy = (double)event.getY() - this.adjustingInitialPosition.getY();
                        double newOrientation = Math.atan2(dy, dx);
                        double newScaleMultiplier = Math.sqrt(dx * dx + dy * dy) / 30.0;
                        if (object instanceof Orientable2D) {
                            ((Orientable2D)object).setOrientation2D(newOrientation);
                        }
                        if (object instanceof Scalable2D) {
                            ((Scalable2D)object).setScale2D(this.adjustingInitialScale * newScaleMultiplier);
                        }
                        return true;
                    }
                    if (id == 502 && this.adjusting) {
                        this.adjusting = false;
                        this.adjustingObject = null;
                        this.adjustingInitialScale = 1.0;
                        this.adjustingInitialPosition = null;
                    }
                }
            }
        }
        return this.getChild(wrapper.getObject()).handleMouseEvent(guistate, manipulating, wrapper, event, range, type);
    }

    @Override
    public boolean hitObject(Object object, DrawInfo2D range) {
        return this.getChild(object).hitObject(object, range);
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        Object object = wrapper.getObject();
        if (!selected && this.adjusting && object == this.adjustingObject) {
            this.adjusting = false;
        }
        return this.getChild(wrapper.getObject()).setSelected(wrapper, selected);
    }

    @Override
    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        return this.getChild(wrapper.getObject()).getInspector(wrapper, state);
    }

    @Override
    public String getName(LocationWrapper wrapper) {
        return this.getChild(wrapper.getObject()).getName(wrapper);
    }
}

