/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.Graphics2D;
import sim.display.GUIState;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.SimplePortrayal2D;
import sim.util.Valuable;

public class FacetedPortrayal2D
extends SimplePortrayal2D {
    public SimplePortrayal2D[] children;
    boolean portrayAllChildren = false;
    boolean errorThrown;

    public FacetedPortrayal2D(SimplePortrayal2D[] children, boolean portrayAllChildren) {
        this.children = children;
        this.portrayAllChildren = portrayAllChildren;
    }

    public FacetedPortrayal2D(SimplePortrayal2D[] children) {
        this(children, false);
    }

    public int getChildIndex(Object object, int numIndices) {
        int element = 0;
        if (object instanceof Number) {
            element = (int)((Number)object).doubleValue();
        } else if (object instanceof Valuable) {
            element = (int)((Valuable)object).doubleValue();
        }
        if (element < 0 || element >= this.children.length) {
            if (!this.errorThrown) {
                this.errorThrown = true;
                System.err.println("WARNING: FacetedPortrayal was given a value that doesn't correspond to any array element.");
            }
            element = 0;
        }
        return element;
    }

    SimplePortrayal2D getChild(Object object) {
        int element = this.getChildIndex(object, this.children.length);
        if (this.children[element] == null) {
            if (object instanceof SimplePortrayal2D) {
                return (SimplePortrayal2D)object;
            }
            throw new RuntimeException("FacetedPortrayal had a null child but the object is not itself a SimplePortrayal2D");
        }
        return this.children[element];
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        if (this.portrayAllChildren) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].draw(object, graphics, info);
            }
        } else {
            this.getChild(object).draw(object, graphics, info);
        }
    }

    @Override
    public boolean hitObject(Object object, DrawInfo2D range) {
        if (this.portrayAllChildren) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!this.children[i].hitObject(object, range)) continue;
                return true;
            }
            return false;
        }
        return this.getChild(object).hitObject(object, range);
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        if (this.portrayAllChildren) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!this.children[i].setSelected(wrapper, selected)) continue;
                return true;
            }
            return false;
        }
        return this.getChild(wrapper.getObject()).setSelected(wrapper, selected);
    }

    @Override
    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        if (this.portrayAllChildren) {
            return this.children[0].getInspector(wrapper, state);
        }
        return this.getChild(wrapper.getObject()).getInspector(wrapper, state);
    }

    @Override
    public String getName(LocationWrapper wrapper) {
        if (this.portrayAllChildren) {
            return this.children[0].getName(wrapper);
        }
        return this.getChild(wrapper.getObject()).getName(wrapper);
    }
}

