/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.simple.RectanglePortrayal2D;

public class ImagePortrayal2D
extends RectanglePortrayal2D {
    public Image image;
    AffineTransform preciseTransform = new AffineTransform();

    public ImagePortrayal2D(ImageIcon icon, double scale) {
        this(icon.getImage(), scale);
    }

    public ImagePortrayal2D(ImageIcon icon) {
        this(icon, 1.0);
    }

    public ImagePortrayal2D(Class c, String resourceName, double scale) {
        this(new ImageIcon(c.getResource(resourceName)), scale);
    }

    public ImagePortrayal2D(Class c, String resourceName) {
        this(c, resourceName, 1.0);
    }

    public ImagePortrayal2D(Image image) {
        this(image, 1.0);
    }

    public ImagePortrayal2D(Image image, double scale) {
        super(null, scale);
        this.image = image;
        this.scale = scale;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        double height;
        double width;
        if (this.image == null) {
            return;
        }
        int iw = this.image.getWidth(null);
        int ih = this.image.getHeight(null);
        if (ih > iw) {
            width = info.draw.width * this.scale;
            height = (double)ih * width / (double)iw;
        } else {
            height = info.draw.height * this.scale;
            width = (double)iw * height / (double)ih;
        }
        double x = info.draw.x - width / 2.0;
        double y = info.draw.y - height / 2.0;
        if (info.precise) {
            this.preciseTransform.setToScale(width, height);
            this.preciseTransform.translate(x, y);
            graphics.drawImage(this.image, this.preciseTransform, null);
        } else {
            graphics.drawImage(this.image, (int)x, (int)y, (int)width, (int)height, null);
        }
    }
}

