/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import sim.display.GUIState;
import sim.display.Manipulating2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Oriented2D;
import sim.portrayal.SimplePortrayal2D;

public class OrientedPortrayal2D
extends SimplePortrayal2D {
    public static final double DEFAULT_SCALE = 0.5;
    public static final int DEFAULT_OFFSET = 0;
    public static final int SHAPE_LINE = 0;
    public static final int SHAPE_KITE = 1;
    public static final int SHAPE_COMPASS = 2;
    int shape = 0;
    public double scale;
    public int offset;
    public Paint paint;
    public SimplePortrayal2D child;
    boolean showOrientation = true;
    public boolean drawFilled = true;
    Shape path = null;
    boolean onlyDrawWhenSelected = false;
    int[] simplePolygonX = new int[4];
    int[] simplePolygonY = new int[4];
    double[] simplePolygonXd = new double[4];
    double[] simplePolygonYd = new double[4];
    double lastLength = Double.NaN;
    AffineTransform transform = new AffineTransform();
    Stroke stroke = new BasicStroke();
    boolean orientationHittable = true;

    public void setDrawFilled(boolean val) {
        this.drawFilled = val;
    }

    public boolean isDrawFilled() {
        return this.drawFilled;
    }

    public void setShape(int val) {
        if (val >= 0 && val <= 2) {
            this.shape = val;
        }
        this.path = null;
    }

    public int getShape() {
        return this.shape;
    }

    public boolean isOrientationShowing() {
        return this.showOrientation;
    }

    public void setOrientationShowing(boolean val) {
        this.showOrientation = val;
    }

    public boolean isLineShowing() {
        return this.showOrientation;
    }

    public void setLineShowing(boolean val) {
        this.showOrientation = val;
    }

    Shape buildPolygon(double[] xpoints, double[] ypoints) {
        GeneralPath path = new GeneralPath();
        if (xpoints.length > 0) {
            path.moveTo((float)xpoints[0], (float)ypoints[0]);
        }
        for (int i = xpoints.length - 1; i >= 0; --i) {
            path.lineTo((float)xpoints[i], (float)ypoints[i]);
        }
        return path;
    }

    public void setOnlyDrawWhenSelected(boolean val) {
        this.onlyDrawWhenSelected = val;
    }

    public boolean getOnlyDrawWhenSelected() {
        return this.onlyDrawWhenSelected;
    }

    public OrientedPortrayal2D(SimplePortrayal2D child, int offset, double scale, Paint paint, int shape) {
        this.offset = offset;
        this.scale = scale;
        this.child = child;
        this.paint = paint;
        this.setShape(shape);
    }

    public OrientedPortrayal2D(SimplePortrayal2D child, int offset, double scale, Paint paint) {
        this(child, offset, scale, paint, 0);
    }

    public OrientedPortrayal2D(SimplePortrayal2D child) {
        this(child, 0, 0.5, Color.red);
    }

    public OrientedPortrayal2D(SimplePortrayal2D child, int offset, double scale) {
        this(child, offset, scale, Color.red);
    }

    public OrientedPortrayal2D(SimplePortrayal2D child, Paint paint) {
        this(child, 0, 0.5, paint);
    }

    public SimplePortrayal2D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal2D)) {
            throw new RuntimeException("Object provided to OrientedPortrayal2D is not a SimplePortrayal2D: " + object);
        }
        return (SimplePortrayal2D)object;
    }

    public double getOrientation(Object object, DrawInfo2D info) {
        if (object != null && object instanceof Oriented2D) {
            return ((Oriented2D)object).orientation2D();
        }
        return Double.NaN;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        double theta;
        if (this.shape == 0 || !this.drawFilled) {
            this.getChild(object).draw(object, graphics, info);
        }
        if (this.showOrientation && (info.selected || !this.onlyDrawWhenSelected) && (theta = this.getOrientation(object, info)) == theta) {
            double length = this.scale * (info.draw.width < info.draw.height ? info.draw.width : info.draw.height) + (double)this.offset;
            if (length != this.lastLength) {
                this.lastLength = length;
                this.path = null;
            }
            graphics.setPaint(this.paint);
            if (info.precise) {
                this.transform.setToTranslation(info.draw.x, info.draw.y);
                this.transform.rotate(theta);
                double lenx = 1.0 * length;
                double leny = 0.0 * length;
                switch (this.shape) {
                    default: {
                        if (this.path == null) {
                            this.path = new Line2D.Double(0.0, 0.0, 0.0, length);
                        }
                        graphics.setStroke(this.stroke);
                        graphics.draw(this.transform.createTransformedShape(this.path));
                        break;
                    }
                    case 1: {
                        if (this.path == null) {
                            this.simplePolygonXd[0] = 0.0 + lenx;
                            this.simplePolygonYd[0] = 0.0 + leny;
                            this.simplePolygonXd[1] = 0.0 + -leny + -lenx;
                            this.simplePolygonYd[1] = 0.0 + lenx + -leny;
                            this.simplePolygonXd[2] = 0.0 + -lenx / 2.0;
                            this.simplePolygonYd[2] = 0.0 + -leny / 2.0;
                            this.simplePolygonXd[3] = 0.0 + leny + -lenx;
                            this.simplePolygonYd[3] = 0.0 + -lenx + -leny;
                            this.path = this.buildPolygon(this.simplePolygonXd, this.simplePolygonYd);
                        }
                        if (this.drawFilled) {
                            graphics.fill(this.transform.createTransformedShape(this.path));
                            break;
                        }
                        graphics.setStroke(this.stroke);
                        graphics.draw(this.transform.createTransformedShape(this.path));
                        break;
                    }
                    case 2: {
                        if (this.path == null) {
                            this.simplePolygonXd[0] = 0.0 + lenx;
                            this.simplePolygonYd[0] = 0.0 + leny;
                            this.simplePolygonXd[1] = 0.0 + -leny / 2.0;
                            this.simplePolygonYd[1] = 0.0 + lenx / 2.0;
                            this.simplePolygonXd[2] = 0.0 + -lenx / 2.0;
                            this.simplePolygonYd[2] = 0.0 + -leny / 2.0;
                            this.simplePolygonXd[3] = 0.0 + leny / 2.0;
                            this.simplePolygonYd[3] = 0.0 + -lenx / 2.0;
                            this.path = this.buildPolygon(this.simplePolygonXd, this.simplePolygonYd);
                        }
                        if (this.drawFilled) {
                            graphics.fill(this.transform.createTransformedShape(this.path));
                            break;
                        }
                        graphics.setStroke(this.stroke);
                        graphics.draw(this.transform.createTransformedShape(this.path));
                        break;
                    }
                }
            } else {
                double lenx = Math.cos(theta) * length;
                double leny = Math.sin(theta) * length;
                switch (this.shape) {
                    default: {
                        graphics.drawLine((int)info.draw.x, (int)info.draw.y, (int)(info.draw.x + lenx), (int)(info.draw.y + leny));
                        break;
                    }
                    case 1: {
                        this.simplePolygonX[0] = (int)(info.draw.x + lenx);
                        this.simplePolygonY[0] = (int)(info.draw.y + leny);
                        this.simplePolygonX[1] = (int)(info.draw.x + -leny + -lenx);
                        this.simplePolygonY[1] = (int)(info.draw.y + lenx + -leny);
                        this.simplePolygonX[2] = (int)(info.draw.x + -lenx / 2.0);
                        this.simplePolygonY[2] = (int)(info.draw.y + -leny / 2.0);
                        this.simplePolygonX[3] = (int)(info.draw.x + leny + -lenx);
                        this.simplePolygonY[3] = (int)(info.draw.y + -lenx + -leny);
                        if (this.drawFilled) {
                            graphics.fillPolygon(this.simplePolygonX, this.simplePolygonY, 4);
                            break;
                        }
                        graphics.drawPolygon(this.simplePolygonX, this.simplePolygonY, 4);
                        break;
                    }
                    case 2: {
                        this.simplePolygonX[0] = (int)(info.draw.x + lenx);
                        this.simplePolygonY[0] = (int)(info.draw.y + leny);
                        this.simplePolygonX[1] = (int)(info.draw.x + -leny / 2.0);
                        this.simplePolygonY[1] = (int)(info.draw.y + lenx / 2.0);
                        this.simplePolygonX[2] = (int)(info.draw.x + -lenx / 2.0);
                        this.simplePolygonY[2] = (int)(info.draw.y + -leny / 2.0);
                        this.simplePolygonX[3] = (int)(info.draw.x + leny / 2.0);
                        this.simplePolygonY[3] = (int)(info.draw.y + -lenx / 2.0);
                        if (this.drawFilled) {
                            graphics.fillPolygon(this.simplePolygonX, this.simplePolygonY, 4);
                            break;
                        }
                        graphics.drawPolygon(this.simplePolygonX, this.simplePolygonY, 4);
                    }
                }
            }
        }
        if (this.shape != 0 && this.drawFilled) {
            this.getChild(object).draw(object, graphics, info);
        }
    }

    public boolean isOrientationHittable() {
        return this.orientationHittable;
    }

    public void setOrientationHittable(boolean val) {
        this.orientationHittable = val;
    }

    @Override
    public boolean hitObject(Object object, DrawInfo2D range) {
        if (this.getChild(object).hitObject(object, range)) {
            return true;
        }
        if (!this.orientationHittable) {
            return false;
        }
        if (this.showOrientation && object != null && object instanceof Oriented2D) {
            double theta = ((Oriented2D)object).orientation2D();
            double length = this.scale * (range.draw.width < range.draw.height ? range.draw.width : range.draw.height) + (double)this.offset;
            this.transform.setToTranslation(range.draw.x, range.draw.y);
            this.transform.rotate(theta);
            double lenx = 1.0 * length;
            double leny = 0.0 * length;
            switch (this.shape) {
                default: {
                    break;
                }
                case 1: {
                    if (this.path == null) {
                        this.simplePolygonXd[0] = 0.0 + lenx;
                        this.simplePolygonYd[0] = 0.0 + leny;
                        this.simplePolygonXd[1] = 0.0 + -leny + -lenx;
                        this.simplePolygonYd[1] = 0.0 + lenx + -leny;
                        this.simplePolygonXd[2] = 0.0 + -lenx / 2.0;
                        this.simplePolygonYd[2] = 0.0 + -leny / 2.0;
                        this.simplePolygonXd[3] = 0.0 + leny + -lenx;
                        this.simplePolygonYd[3] = 0.0 + -lenx + -leny;
                        this.path = this.buildPolygon(this.simplePolygonXd, this.simplePolygonYd);
                    }
                    return this.transform.createTransformedShape(this.path).intersects(range.clip.x, range.clip.y, range.clip.width, range.clip.height);
                }
                case 2: {
                    if (this.path == null) {
                        this.simplePolygonXd[0] = 0.0 + lenx;
                        this.simplePolygonYd[0] = 0.0 + leny;
                        this.simplePolygonXd[1] = 0.0 + -leny / 2.0;
                        this.simplePolygonYd[1] = 0.0 + lenx / 2.0;
                        this.simplePolygonXd[2] = 0.0 + -lenx / 2.0;
                        this.simplePolygonYd[2] = 0.0 + -leny / 2.0;
                        this.simplePolygonXd[3] = 0.0 + leny / 2.0;
                        this.simplePolygonYd[3] = 0.0 + -lenx / 2.0;
                        this.path = this.buildPolygon(this.simplePolygonXd, this.simplePolygonYd);
                    }
                    return this.transform.createTransformedShape(this.path).intersects(range.clip.x, range.clip.y, range.clip.width, range.clip.height);
                }
            }
        }
        return false;
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        return this.getChild(wrapper.getObject()).setSelected(wrapper, selected);
    }

    @Override
    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        return this.getChild(wrapper.getObject()).getInspector(wrapper, state);
    }

    @Override
    public String getName(LocationWrapper wrapper) {
        return this.getChild(wrapper.getObject()).getName(wrapper);
    }

    @Override
    public boolean handleMouseEvent(GUIState guistate, Manipulating2D manipulating, LocationWrapper wrapper, MouseEvent event, DrawInfo2D fieldPortrayalDrawInfo, int type) {
        return this.getChild(wrapper.getObject()).handleMouseEvent(guistate, manipulating, wrapper, event, fieldPortrayalDrawInfo, type);
    }
}

