/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import sim.display.GUIState;
import sim.display.Manipulating2D;
import sim.field.continuous.Continuous2D;
import sim.field.grid.Grid2D;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.FieldPortrayal2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.SimplePortrayal2D;
import sim.portrayal.network.EdgeDrawInfo2D;
import sim.portrayal.network.SimpleEdgePortrayal2D;
import sim.util.Double2D;
import sim.util.Int2D;
import sim.util.gui.SimpleColorMap;

public class TrailedPortrayal2D
extends SimplePortrayal2D {
    boolean isSelected = false;
    boolean onlyGrowTrailWhenSelected = false;
    boolean onlyShowTrailWhenSelected = true;
    LinkedList places = new LinkedList();
    SimpleColorMap defaultMap;
    public SimplePortrayal2D child;
    public SimplePortrayal2D trail;
    double length;
    GUIState state;
    FieldPortrayal2D fieldPortrayal;
    public static final double DEFAULT_MAXIMUM_JUMP = 0.75;
    public double maximumJump = 0.75;
    public static final Color DEFAULT_MIN_COLOR = new Color(128, 128, 128, 255);
    public static final Color DEFAULT_MAX_COLOR = new Color(128, 128, 128, 0);
    static final Object NO_OBJ = new Object();
    static final Object NO_OBJ2 = new Object();
    Object lastObj;
    Object selectedObj;
    boolean locked = false;

    public void setOnlyGrowTrailWhenSelected(boolean val) {
        this.onlyGrowTrailWhenSelected = val;
    }

    public void setGrowTrailOnlyWhenSelected(boolean val) {
        this.onlyGrowTrailWhenSelected = val;
    }

    public boolean getOnlyGrowTrailWhenSelected() {
        return this.onlyGrowTrailWhenSelected;
    }

    public boolean getGrowTrailOnlyWhenSelected() {
        return this.onlyGrowTrailWhenSelected;
    }

    public void setOnlyShowTrailWhenSelected(boolean val) {
        this.onlyShowTrailWhenSelected = val;
    }

    public boolean getOnlyShowTrailWhenSelected() {
        return this.onlyShowTrailWhenSelected;
    }

    public void setLength(double val) {
        if (val >= 0.0) {
            this.length = val;
        }
    }

    public double getLength() {
        return this.length;
    }

    public void setMaximumJump(double val) {
        if (val >= 0.0 && val <= 1.0) {
            this.maximumJump = val;
        }
    }

    public double getMaximumJump() {
        return this.maximumJump;
    }

    public TrailedPortrayal2D(GUIState state, SimplePortrayal2D child, FieldPortrayal2D fieldPortrayal, SimplePortrayal2D trail, double length) {
        this.state = state;
        this.child = child;
        this.trail = trail;
        this.length = length;
        this.fieldPortrayal = fieldPortrayal;
        this.defaultMap = new SimpleColorMap(0.0, 1.0, DEFAULT_MIN_COLOR, DEFAULT_MAX_COLOR);
    }

    public TrailedPortrayal2D(GUIState state, SimplePortrayal2D child, FieldPortrayal2D fieldPortrayal, double length, Color minColor, Color maxColor) {
        this.state = state;
        this.child = child;
        this.trail = new DefaultTrail();
        this.length = length;
        this.fieldPortrayal = fieldPortrayal;
        this.defaultMap = new SimpleColorMap(0.0, 1.0, minColor, maxColor);
    }

    public TrailedPortrayal2D(GUIState state, SimplePortrayal2D child, FieldPortrayal2D fieldPortrayal, double length) {
        this(state, child, fieldPortrayal, length, DEFAULT_MIN_COLOR, DEFAULT_MAX_COLOR);
    }

    SimplePortrayal2D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal2D)) {
            throw new RuntimeException("Object provided to TransformedPortrayal2D is not a SimplePortrayal2D: " + object);
        }
        return (SimplePortrayal2D)object;
    }

    double valueForTimestep(double timestamp, double currentTime) {
        if (this.length == 0.0) {
            return 0.0;
        }
        double val = (currentTime - timestamp) / this.length;
        if (val < 0.0) {
            return 0.0;
        }
        if (val > 1.0) {
            return 1.0;
        }
        return val;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        ListIterator iterator;
        double currentTime;
        if (info.fieldPortrayal != this.fieldPortrayal) {
            if (info.selected && !this.locked) {
                this.selectedObj = object;
                if (this.selectedObj == this.lastObj) {
                    this.locked = true;
                }
            } else if (this.selectedObj == object) {
                this.selectedObj = NO_OBJ2;
            }
            this.getChild(object).draw(object, graphics, info);
            return;
        }
        Object selectedObj = this.selectedObj;
        Object lastObj = this.lastObj;
        boolean onlyShowTrailWhenSelected = this.onlyShowTrailWhenSelected;
        boolean onlyGrowTrailWhenSelected = this.onlyGrowTrailWhenSelected;
        this.locked = false;
        if ((object == selectedObj || !onlyShowTrailWhenSelected) && object != lastObj && onlyGrowTrailWhenSelected) {
            this.places.clear();
            lastObj = object;
        }
        Object currentObjectLocation = NO_OBJ;
        if (object == selectedObj || !onlyGrowTrailWhenSelected) {
            currentTime = this.state.state.schedule.getTime();
            iterator = this.places.listIterator();
            while (iterator.hasNext()) {
                Place p = (Place)iterator.next();
                if (!(p.timestamp <= currentTime - this.length)) break;
                iterator.remove();
            }
            int size = this.places.size();
            currentObjectLocation = this.fieldPortrayal.getObjectLocation(object, info.gui);
            if (size == 0 && currentTime > -1.0 && currentTime < Double.POSITIVE_INFINITY) {
                this.places.add(new Place(currentObjectLocation, currentTime));
            } else if (size > 0) {
                Place lastPlace = (Place)this.places.getLast();
                if (lastPlace.timestamp < currentTime) {
                    this.places.add(new Place(currentObjectLocation, currentTime));
                }
            }
        }
        if (object == selectedObj || !onlyShowTrailWhenSelected) {
            if (currentObjectLocation == NO_OBJ) {
                currentObjectLocation = this.fieldPortrayal.getObjectLocation(object, info.gui);
            }
            currentTime = this.state.state.schedule.getTime();
            iterator = this.places.listIterator();
            Place lastPlace = null;
            Point2D.Double lastPosition = null;
            TrailDrawInfo2D temp = new TrailDrawInfo2D(info.gui, info.fieldPortrayal, new Rectangle2D.Double(info.draw.x, info.draw.y, info.draw.width, info.draw.height), info.clip, null);
            while (iterator.hasNext()) {
                Place p = (Place)iterator.next();
                Point2D.Double position = this.fieldPortrayal.getRelativeObjectPosition(p.location, currentObjectLocation, info);
                if (lastPosition != null) {
                    Serializable loc2;
                    Serializable loc1;
                    Serializable grid;
                    boolean jump = false;
                    Object field = this.fieldPortrayal.getField();
                    double width = 0.0;
                    double height = 0.0;
                    if (field instanceof Grid2D) {
                        grid = (Grid2D)field;
                        width = grid.getWidth();
                        height = grid.getHeight();
                        loc1 = (Int2D)p.location;
                        loc2 = (Int2D)lastPlace.location;
                        jump = (double)Math.abs(loc1.x - loc2.x) > width * this.maximumJump || (double)Math.abs(loc1.y - loc2.y) > height * this.maximumJump;
                    } else if (field instanceof Continuous2D) {
                        grid = (Continuous2D)field;
                        width = ((Continuous2D)grid).getWidth();
                        height = ((Continuous2D)grid).getHeight();
                        loc1 = (Double2D)p.location;
                        loc2 = (Double2D)lastPlace.location;
                        boolean bl = jump = Math.abs(((Double2D)loc1).x - ((Double2D)loc2).x) > width * this.maximumJump || Math.abs(((Double2D)loc1).y - ((Double2D)loc2).y) > height * this.maximumJump;
                    }
                    if (!jump) {
                        temp.value = this.valueForTimestep(p.timestamp, currentTime);
                        temp.draw.x = position.x;
                        temp.draw.y = position.y;
                        temp.secondPoint = lastPosition;
                        this.trail.draw(object, graphics, temp);
                    }
                }
                lastPlace = p;
                lastPosition = position;
            }
        }
    }

    @Override
    public boolean hitObject(Object object, DrawInfo2D range) {
        return this.getChild(object).hitObject(object, range);
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        Object object = wrapper.getObject();
        boolean returnval = this.getChild(object).setSelected(wrapper, selected);
        return returnval;
    }

    @Override
    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        Object object = wrapper.getObject();
        if (wrapper.getFieldPortrayal() != this.fieldPortrayal) {
            return this.getChild(object).getInspector(wrapper, state);
        }
        return null;
    }

    @Override
    public String getName(LocationWrapper wrapper) {
        Object object = wrapper.getObject();
        if (wrapper.getFieldPortrayal() != this.fieldPortrayal) {
            return this.getChild(object).getName(wrapper);
        }
        return null;
    }

    @Override
    public boolean handleMouseEvent(GUIState guistate, Manipulating2D manipulating, LocationWrapper wrapper, MouseEvent event, DrawInfo2D fieldPortrayalDrawInfo, int type) {
        return this.getChild(wrapper.getObject()).handleMouseEvent(guistate, manipulating, wrapper, event, fieldPortrayalDrawInfo, type);
    }

    class DefaultTrail
    extends SimpleEdgePortrayal2D {
        BasicStroke stroke = new BasicStroke(0.5f, 1, 1);

        DefaultTrail() {
        }

        @Override
        public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
            info.precise = true;
            float linewidth = this.stroke.getLineWidth();
            if ((double)(linewidth * 2.0f) != info.draw.width) {
                this.stroke = new BasicStroke((float)(info.draw.width / 2.0), 1, 1);
            }
            graphics.setStroke(this.stroke);
            TrailDrawInfo2D t = (TrailDrawInfo2D)info;
            this.toPaint = this.fromPaint = TrailedPortrayal2D.this.defaultMap.getColor(t.value);
            super.draw(object, graphics, info);
        }
    }

    static class Place {
        Object location;
        double timestamp;

        Place(Object location, double timestamp) {
            this.location = location;
            this.timestamp = timestamp;
        }
    }

    public static class TrailDrawInfo2D
    extends EdgeDrawInfo2D {
        public double value = 0.0;

        public TrailDrawInfo2D(GUIState gui, FieldPortrayal2D fieldPortrayal, RectangularShape draw, RectangularShape clip, Point2D.Double secondPoint) {
            super(gui, fieldPortrayal, draw, clip, secondPoint);
        }

        public TrailDrawInfo2D(DrawInfo2D other, double translateX, double translateY, Point2D.Double secondPoint) {
            super(other, translateX, translateY, secondPoint);
        }

        public TrailDrawInfo2D(DrawInfo2D other, Point2D.Double secondPoint) {
            super(other, secondPoint);
        }

        public TrailDrawInfo2D(EdgeDrawInfo2D other) {
            super(other);
        }
    }
}

