/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal.simple;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import sim.display.GUIState;
import sim.portrayal.DrawInfo2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Oriented2D;
import sim.portrayal.SimplePortrayal2D;

public class TransformedPortrayal2D
extends SimplePortrayal2D {
    public SimplePortrayal2D child;
    public AffineTransform transform;

    public TransformedPortrayal2D(SimplePortrayal2D child, AffineTransform transform) {
        this.child = child;
        this.transform = transform;
    }

    public SimplePortrayal2D getChild(Object object) {
        if (this.child != null) {
            return this.child;
        }
        if (!(object instanceof SimplePortrayal2D)) {
            throw new RuntimeException("Object provided to TransformedPortrayal2D is not a SimplePortrayal2D: " + object);
        }
        return (SimplePortrayal2D)object;
    }

    @Override
    public void draw(Object object, Graphics2D graphics, DrawInfo2D info) {
        double theta = ((Oriented2D)object).orientation2D();
        this.transform.setToRotation(theta);
        AffineTransform old = graphics.getTransform();
        AffineTransform translationTransform = new AffineTransform();
        translationTransform.setToTranslation(info.draw.x, info.draw.y);
        graphics.transform(translationTransform);
        graphics.transform(this.transform);
        this.getChild(object).draw(object, graphics, new DrawInfo2D(info, -info.draw.x, -info.draw.y));
        graphics.setTransform(old);
    }

    @Override
    public boolean hitObject(Object object, DrawInfo2D range) {
        return false;
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        return this.getChild(wrapper.getObject()).setSelected(wrapper, selected);
    }

    @Override
    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        return this.getChild(wrapper.getObject()).getInspector(wrapper, state);
    }

    @Override
    public String getName(LocationWrapper wrapper) {
        return this.getChild(wrapper.getObject()).getName(wrapper);
    }
}

