/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;
import sim.display.GUIState;
import sim.display3d.Display3D;
import sim.portrayal.FieldPortrayal;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal3d.Portrayal3D;
import sim.portrayal3d.SimplePortrayal3D;
import sim.portrayal3d.simple.SpherePortrayal3D;

public abstract class FieldPortrayal3D
extends FieldPortrayal
implements Portrayal3D {
    Transform3D internalTransform;
    boolean updateInternalTransform = false;
    Display3D display = null;
    SimplePortrayal3D defaultPortrayal = new SpherePortrayal3D();

    @Override
    public PolygonAttributes polygonAttributes() {
        return null;
    }

    @Override
    public void setCurrentDisplay(Display3D display) {
        this.display = display;
    }

    @Override
    public Display3D getCurrentDisplay() {
        return this.display;
    }

    @Override
    public GUIState getCurrentGUIState() {
        Display3D d = this.getCurrentDisplay();
        return d == null ? null : d.getSimulation();
    }

    public void setTransform(Transform3D transform) {
        this.internalTransform = transform == null ? this.getDefaultTransform() : new Transform3D(transform);
        this.updateInternalTransform = true;
    }

    protected Transform3D getDefaultTransform() {
        return new Transform3D();
    }

    public Transform3D getTransform() {
        return new Transform3D(this.internalTransform);
    }

    public void transform(Transform3D transform) {
        Transform3D current = this.getTransform();
        current.mul(transform, current);
        this.setTransform(current);
    }

    public void resetTransform() {
        this.setTransform(this.getDefaultTransform());
    }

    public void rotateX(double degrees) {
        Transform3D other = new Transform3D();
        other.rotX(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void rotateY(double degrees) {
        Transform3D other = new Transform3D();
        other.rotY(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void rotateZ(double degrees) {
        Transform3D other = new Transform3D();
        other.rotZ(degrees * Math.PI / 180.0);
        this.transform(other);
    }

    public void translate(double dx, double dy, double dz) {
        Transform3D other = new Transform3D();
        other.setTranslation(new Vector3d(dx, dy, dz));
        this.transform(other);
    }

    public void scale(double value) {
        Transform3D other = new Transform3D();
        other.setScale(value);
        this.transform(other);
    }

    public void scale(double sx, double sy, double sz) {
        Transform3D other = new Transform3D();
        other.setScale(new Vector3d(sx, sy, sz));
        this.transform(other);
    }

    public FieldPortrayal3D() {
        this(null);
    }

    public FieldPortrayal3D(Transform3D transform) {
        this.setTransform(transform);
    }

    @Override
    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    @Override
    public TransformGroup getModel(Object obj, TransformGroup previousTransformGroup) {
        TransformGroup internalTransformGroup;
        if (previousTransformGroup == null) {
            internalTransformGroup = this.createModel();
            internalTransformGroup.setCapability(18);
            this.updateInternalTransform = true;
            previousTransformGroup = new TransformGroup();
            previousTransformGroup.setCapability(12);
            previousTransformGroup.clearCapabilityIsFrequent(12);
            previousTransformGroup.addChild((Node)internalTransformGroup);
        } else {
            internalTransformGroup = (TransformGroup)previousTransformGroup.getChild(0);
            if (!this.immutableField || this.isDirtyField()) {
                this.updateModel(internalTransformGroup);
            }
        }
        if (this.updateInternalTransform) {
            internalTransformGroup.setTransform(this.internalTransform);
        }
        this.setDirtyField(false);
        return previousTransformGroup;
    }

    protected abstract TransformGroup createModel();

    protected void updateModel(TransformGroup previousTransformGroup) {
    }

    public abstract LocationWrapper completedWrapper(LocationWrapper var1, PickIntersection var2, PickResult var3);
}

