/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d;

import java.util.HashMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;
import sim.field.SparseField;
import sim.portrayal.Portrayal;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.SimplePortrayal3D;
import sim.util.Bag;

public abstract class SparseFieldPortrayal3D
extends FieldPortrayal3D {
    public abstract Vector3d getLocationOfObjectAsVector3d(Object var1, Vector3d var2);

    @Override
    public TransformGroup createModel() {
        SparseField field = (SparseField)this.field;
        Vector3d locationV3d = new Vector3d();
        TransformGroup globalTG = new TransformGroup();
        globalTG.setCapability(12);
        globalTG.setCapability(13);
        globalTG.setCapability(14);
        if (field == null) {
            return globalTG;
        }
        Bag objects = field.getAllObjects();
        Transform3D tmpLocalT = new Transform3D();
        for (int z = 0; z < objects.numObjs; ++z) {
            this.getLocationOfObjectAsVector3d(objects.objs[z], locationV3d);
            tmpLocalT.setTranslation(locationV3d);
            globalTG.addChild((Node)this.wrapModelForNewObject(objects.objs[z], tmpLocalT));
        }
        return globalTG;
    }

    protected BranchGroup wrapModelForNewObject(Object o, Transform3D localT) {
        Portrayal p = this.getPortrayalForObject(o);
        if (!(p instanceof SimplePortrayal3D)) {
            throw new RuntimeException("Unexpected Portrayal " + p + " for object " + o + " -- expecting a SimplePortrayal3D");
        }
        SimplePortrayal3D p3d = (SimplePortrayal3D)p;
        p3d.setCurrentFieldPortrayal(this);
        TransformGroup localTG = p3d.getModel(o, null);
        localTG.setCapability(18);
        localTG.setCapability(17);
        localTG.setTransform(localT);
        BranchGroup localBG = new BranchGroup();
        localBG.setCapability(12);
        localBG.setCapability(17);
        localBG.addChild((Node)localTG);
        localBG.setUserData(o);
        return localBG;
    }

    @Override
    public void updateModel(TransformGroup globalTG) {
        SparseField field = (SparseField)this.field;
        if (field == null) {
            return;
        }
        Bag b = field.getAllObjects();
        HashMap<Object, Object> hm = new HashMap<Object, Object>();
        Transform3D tmpLocalT = new Transform3D();
        Vector3d locationV3d = new Vector3d();
        for (int i = 0; i < b.numObjs; ++i) {
            hm.put(b.objs[i], b.objs[i]);
        }
        Bag toRemove = new Bag();
        for (int t = 0; t < globalTG.numChildren(); ++t) {
            BranchGroup localBG = (BranchGroup)globalTG.getChild(t);
            Object fieldObj = localBG.getUserData();
            if (hm.remove(fieldObj) != null) {
                TransformGroup localTG = (TransformGroup)localBG.getChild(0);
                Portrayal p = this.getPortrayalForObject(fieldObj);
                if (!(p instanceof SimplePortrayal3D)) {
                    throw new RuntimeException("Unexpected Portrayal " + p + " for object " + fieldObj + " -- expecting a SimplePortrayal3D");
                }
                SimplePortrayal3D p3d = (SimplePortrayal3D)p;
                p3d.setCurrentFieldPortrayal(this);
                TransformGroup localTG2 = p3d.getModel(fieldObj, localTG);
                this.getLocationOfObjectAsVector3d(fieldObj, locationV3d);
                tmpLocalT.setTranslation(locationV3d);
                localTG2.setTransform(tmpLocalT);
                if (localTG == localTG2) continue;
                localTG2.setCapability(18);
                localTG2.setCapability(17);
                BranchGroup newlocalBG = new BranchGroup();
                newlocalBG.setCapability(12);
                newlocalBG.setCapability(17);
                newlocalBG.setUserData(fieldObj);
                newlocalBG.addChild((Node)localTG2);
                globalTG.setChild((Node)newlocalBG, t);
                continue;
            }
            toRemove.add(localBG);
        }
        for (int i = 0; i < toRemove.numObjs; ++i) {
            globalTG.removeChild((Node)toRemove.objs[i]);
        }
        if (!hm.isEmpty()) {
            for (Object fieldObj : hm.values()) {
                locationV3d = this.getLocationOfObjectAsVector3d(fieldObj, locationV3d);
                if (locationV3d != null) {
                    tmpLocalT.setTranslation(locationV3d);
                }
                BranchGroup localBG = this.wrapModelForNewObject(fieldObj, tmpLocalT);
                globalTG.addChild((Node)localBG);
            }
        }
    }
}

