/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.grid;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import java.awt.Color;
import java.awt.Image;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleFanArray;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4f;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.Grid2D;
import sim.field.grid.IntGrid2D;
import sim.field.grid.ObjectGrid2D;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal3d.FieldPortrayal3D;
import sim.portrayal3d.SimplePortrayal3D;
import sim.portrayal3d.grid.quad.QuadPortrayal;
import sim.portrayal3d.grid.quad.TilePortrayal;
import sim.portrayal3d.grid.quad.ValueGridCellInfo;
import sim.util.Int2D;
import sim.util.MutableDouble;
import sim.util.Valuable;
import sim.util.gui.SimpleColorMap;

public class ValueGrid2DPortrayal3D
extends FieldPortrayal3D {
    Image image;
    double transparency = 1.0;
    PolygonAttributes mPolyAttributes = new PolygonAttributes();
    boolean useTriangles = false;
    String valueName;
    QuadPortrayal defaultPortrayal;
    float[] coords;
    float[] colors;
    boolean resetField = true;
    protected Vector3d tmpVect = new Vector3d();
    protected Transform3D tmpLocalT = new Transform3D();
    private ValueGridCellInfo tmpGCI;

    public boolean isUsingTriangles() {
        return this.useTriangles;
    }

    public void setUsingTriangles(boolean val) {
        this.useTriangles = val;
    }

    @Override
    public Object getField() {
        return this.field;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String name) {
        this.valueName = name;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double transparency) {
        if (transparency >= 0.0 && transparency <= 1.0) {
            this.transparency = transparency;
        }
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public ValueGrid2DPortrayal3D(String valueName, Image image) {
        this(valueName, 1.0);
        this.image = image;
    }

    public ValueGrid2DPortrayal3D(String valueName, double transparency) {
        this.valueName = valueName;
        SimpleColorMap cm = new SimpleColorMap();
        cm.setLevels(0.0, 1.0, Color.blue, Color.red);
        this.defaultPortrayal = new TilePortrayal(cm);
        this.transparency = transparency;
        this.mPolyAttributes.setCapability(1);
        this.mPolyAttributes.setCapability(3);
        this.mPolyAttributes.clearCapabilityIsFrequent(1);
        this.mPolyAttributes.clearCapabilityIsFrequent(3);
    }

    public ValueGrid2DPortrayal3D(String valueName) {
        this(valueName, 1.0);
    }

    public ValueGrid2DPortrayal3D() {
        this("Value");
    }

    @Override
    public PolygonAttributes polygonAttributes() {
        return this.mPolyAttributes;
    }

    @Override
    public Portrayal getDefaultPortrayal() {
        return this.defaultPortrayal;
    }

    @Override
    public void setField(Object grid) {
        if (this.getField() == grid) {
            return;
        }
        if (!(grid instanceof Grid2D)) {
            throw new RuntimeException("ValueGridPortrayal2D3D cannot portray the object: " + grid);
        }
        super.setField(grid);
        Grid2D field = (Grid2D)this.field;
        this.tmpGCI = new ValueGridCellInfo(this, field);
        this.coords = new float[field.getWidth() * field.getHeight() * 4 * 3];
        this.colors = new float[field.getWidth() * field.getHeight() * 4 * 3];
        this.resetField = true;
    }

    public double doubleValue(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Valuable) {
            return ((Valuable)obj).doubleValue();
        }
        return 1.0;
    }

    @Override
    public TransformGroup createModel() {
        Appearance appearance;
        QuadArray ga;
        TransformGroup globalTG = new TransformGroup();
        globalTG.setCapability(12);
        globalTG.setCapability(13);
        globalTG.setCapability(14);
        if (this.field == null) {
            return globalTG;
        }
        QuadPortrayal quadPortrayal = (QuadPortrayal)this.getPortrayalForObject(this.tmpGCI);
        Grid2D field = (Grid2D)this.field;
        if (!this.useTriangles) {
            ga = new QuadArray(4 * field.getWidth() * field.getHeight(), 5 | (this.image != null ? 32 : 0));
        } else {
            int[] lengths = new int[field.getWidth() * field.getHeight()];
            for (int i = 0; i < lengths.length; ++i) {
                lengths[i] = 4;
            }
            ga = new TriangleFanArray(4 * lengths.length, 5 | (this.image != null ? 32 : 0), lengths);
        }
        ga.setCapability(3);
        ga.setCapability(1);
        SimplePortrayal3D.setPickableFlags((Geometry)ga);
        this.tmpVect.z = 0.0;
        int quadIndex = 0;
        int width = field.getWidth();
        int height = field.getHeight();
        for (int i = 0; i < width; ++i) {
            this.tmpGCI.x = i;
            this.tmpVect.x = i;
            for (int j = 0; j < height; ++j) {
                this.tmpGCI.y = j;
                this.tmpVect.y = j;
                quadPortrayal.setData(this.tmpGCI, this.coords, this.colors, quadIndex, width, height);
                ++quadIndex;
            }
        }
        ga.setCoordinates(0, this.coords);
        ga.setColors(0, this.colors);
        Shape3D shape = new Shape3D((Geometry)ga);
        shape.setCapability(12);
        if (this.image != null) {
            appearance = SimplePortrayal3D.appearanceForImage(this.image, true);
            TexCoordGeneration tex = new TexCoordGeneration();
            Vector4f s = new Vector4f(1.0f / (float)width, 0.0f, 0.0f, 0.0f);
            tex.setPlaneS(s);
            Vector4f t = new Vector4f(0.0f, 1.0f / (float)height, 0.0f, 0.0f);
            tex.setPlaneT(t);
            appearance.setTexCoordGeneration(tex);
        } else {
            appearance = new Appearance();
            if (this.transparency < 1.0) {
                appearance.setTransparencyAttributes(new TransparencyAttributes(2, 1.0f - (float)this.transparency));
            }
        }
        appearance.setCapability(15);
        appearance.setPolygonAttributes(this.mPolyAttributes);
        appearance.setColoringAttributes(new ColoringAttributes(1.0f, 1.0f, 1.0f, 3));
        shape.setAppearance(appearance);
        LocationWrapper pi = new LocationWrapper(null, null, this);
        shape.setUserData((Object)pi);
        BranchGroup bg = new BranchGroup();
        bg.setCapability(12);
        bg.setCapability(17);
        bg.addChild((Node)shape);
        globalTG.addChild((Node)bg);
        return globalTG;
    }

    @Override
    public void updateModel(TransformGroup modelTG) {
        if (this.resetField || modelTG.numChildren() == 0) {
            TransformGroup g = this.createModel();
            if (g.numChildren() > 0) {
                Node model = g.getChild(0);
                g.removeChild(0);
                modelTG.removeAllChildren();
                modelTG.addChild(model);
            }
            this.resetField = false;
        } else {
            Grid2D field = (Grid2D)this.field;
            QuadPortrayal quadPortrayal = (QuadPortrayal)this.getPortrayalForObject(this.tmpGCI);
            BranchGroup bg = (BranchGroup)modelTG.getChild(0);
            Shape3D shape = (Shape3D)bg.getChild(0);
            GeometryArray ga = (GeometryArray)shape.getGeometry();
            int quadIndex = 0;
            int width = field.getWidth();
            int height = field.getHeight();
            for (int i = 0; i < width; ++i) {
                this.tmpGCI.x = i;
                int j = 0;
                while (j < height) {
                    this.tmpGCI.y = j++;
                    quadPortrayal.setData(this.tmpGCI, this.coords, this.colors, quadIndex, width, height);
                    ++quadIndex;
                }
            }
            ga.setCoordinates(0, this.coords);
            ga.setColors(0, this.colors);
        }
    }

    public double newValue(int x, int y, double value) {
        if (this.field instanceof IntGrid2D) {
            value = (int)value;
        }
        this.tmpGCI.x = x;
        this.tmpGCI.y = y;
        QuadPortrayal quadPortrayal = (QuadPortrayal)this.getPortrayalForObject(this.tmpGCI);
        if (quadPortrayal.getMap().validLevel(value)) {
            return value;
        }
        if (this.field != null) {
            if (this.field instanceof DoubleGrid2D) {
                return ((DoubleGrid2D)this.field).field[x][y];
            }
            if (this.field instanceof ObjectGrid2D) {
                return this.doubleValue(((ObjectGrid2D)this.field).field[x][y]);
            }
            return ((IntGrid2D)this.field).field[x][y];
        }
        return quadPortrayal.getMap().defaultValue();
    }

    @Override
    public LocationWrapper completedWrapper(LocationWrapper w, PickIntersection pi, PickResult pr) {
        Grid2D field = (Grid2D)this.field;
        return new LocationWrapper(new ValueGridCellInfo(this, field), ((QuadPortrayal)this.getPortrayalForObject(this.tmpGCI)).getCellForIntersection(pi, field), this){
            MutableDouble val;
            {
                this.val = null;
            }

            @Override
            public Object getObject() {
                if (this.val == null) {
                    this.val = new MutableDouble(0.0);
                }
                this.val.val = ((ValueGridCellInfo)this.object).value();
                return this.val;
            }

            @Override
            public String getLocationName() {
                if (this.location != null) {
                    return ((Int2D)this.location).toCoordinates();
                }
                return null;
            }
        };
    }
}

