/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.grid.quad;

import com.sun.j3d.utils.picking.PickIntersection;
import sim.display.GUIState;
import sim.field.grid.DoubleGrid2D;
import sim.field.grid.Grid2D;
import sim.field.grid.IntGrid2D;
import sim.field.grid.ObjectGrid2D;
import sim.portrayal.Inspector;
import sim.portrayal.LocationWrapper;
import sim.portrayal.Portrayal;
import sim.portrayal.SimpleInspector;
import sim.portrayal3d.grid.ValueGrid2DPortrayal3D;
import sim.portrayal3d.grid.quad.ValueGridCellInfo;
import sim.util.Int2D;
import sim.util.MutableDouble;
import sim.util.gui.ColorMap;

public abstract class QuadPortrayal
implements Portrayal {
    double zScale;
    ColorMap colorDispenser;

    public ColorMap getMap() {
        return this.colorDispenser;
    }

    public void setMap(ColorMap map) {
        this.colorDispenser = map;
    }

    public double getZScale() {
        return this.zScale;
    }

    public void setZScale(double scale) {
        this.zScale = scale;
    }

    public abstract void setData(ValueGridCellInfo var1, float[] var2, float[] var3, int var4, int var5, int var6);

    public QuadPortrayal(ColorMap colorDispenser, double zScale) {
        this.colorDispenser = colorDispenser;
        this.zScale = zScale;
    }

    @Override
    public String getStatus(LocationWrapper wrapper) {
        return this.getName(wrapper) + ": " + ((MutableDouble)wrapper.getObject()).val;
    }

    @Override
    public String getName(LocationWrapper wrapper) {
        ValueGrid2DPortrayal3D portrayal = (ValueGrid2DPortrayal3D)wrapper.getFieldPortrayal();
        return portrayal.getValueName() + " at " + wrapper.getLocationName();
    }

    @Override
    public boolean setSelected(LocationWrapper wrapper, boolean selected) {
        return !selected;
    }

    @Override
    public Inspector getInspector(LocationWrapper wrapper, GUIState state) {
        if (wrapper == null) {
            return null;
        }
        Grid2D grid = (Grid2D)((ValueGrid2DPortrayal3D)wrapper.getFieldPortrayal()).getField();
        if (grid instanceof DoubleGrid2D) {
            return new SimpleInspector(new DoubleFilter(wrapper), state, "Properties");
        }
        if (grid instanceof IntGrid2D) {
            return new SimpleInspector(new IntFilter(wrapper), state, "Properties");
        }
        if (grid instanceof ObjectGrid2D) {
            return new SimpleInspector(new ObjectFilter(wrapper), state, "Properties");
        }
        return null;
    }

    public Int2D getCellForIntersection(PickIntersection pi, Grid2D field) {
        int[] indices = pi.getPrimitiveVertexIndices();
        if (indices == null) {
            return null;
        }
        int height = field.getHeight();
        int x = indices[0] / 4 / height;
        int y = indices[0] / 4 % height;
        return new Int2D(x, y);
    }

    public static class IntFilter
    extends Filter {
        public IntFilter(LocationWrapper wrapper) {
            super(wrapper);
        }

        public int getValue() {
            return ((IntGrid2D)this.fieldPortrayal.getField()).field[this.x][this.y];
        }

        public void setValue(int val) {
            ((IntGrid2D)this.fieldPortrayal.getField()).field[this.x][this.y] = (int)this.fieldPortrayal.newValue(this.x, this.y, val);
        }
    }

    public static class DoubleFilter
    extends Filter {
        public DoubleFilter(LocationWrapper wrapper) {
            super(wrapper);
        }

        public double getValue() {
            return ((DoubleGrid2D)this.fieldPortrayal.getField()).field[this.x][this.y];
        }

        public void setValue(double val) {
            ((DoubleGrid2D)this.fieldPortrayal.getField()).field[this.x][this.y] = this.fieldPortrayal.newValue(this.x, this.y, val);
        }
    }

    public static class ObjectFilter
    extends Filter {
        public ObjectFilter(LocationWrapper wrapper) {
            super(wrapper);
        }

        public double getValue() {
            return this.fieldPortrayal.doubleValue(((ObjectGrid2D)this.fieldPortrayal.getField()).field[this.x][this.y]);
        }
    }

    public static abstract class Filter {
        int x;
        int y;
        ValueGrid2DPortrayal3D fieldPortrayal;

        public Filter(LocationWrapper wrapper) {
            this.fieldPortrayal = (ValueGrid2DPortrayal3D)wrapper.getFieldPortrayal();
            Int2D loc = (Int2D)wrapper.getLocation();
            this.x = loc.x;
            this.y = loc.y;
        }
    }
}

