/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.grid.quad;

import sim.portrayal3d.grid.quad.QuadPortrayal;
import sim.portrayal3d.grid.quad.ValueGridCellInfo;
import sim.util.gui.ColorMap;

public class TilePortrayal
extends QuadPortrayal {
    float[] tmpCoords = new float[12];
    float[] tmpColor = new float[4];

    public TilePortrayal(ColorMap colorDispenser) {
        this(colorDispenser, 0.0);
    }

    public TilePortrayal(ColorMap colorDispenser, double zScale) {
        super(colorDispenser, zScale);
    }

    @Override
    public void setData(ValueGridCellInfo gridCell, float[] coordinates, float[] colors, int quadIndex, int gridWidth, int gridHeight) {
        int x = gridCell.x;
        int y = gridCell.y;
        float value = (float)gridCell.value();
        this.colorDispenser.getColor(value).getComponents(this.tmpColor);
        value = (float)((double)value * this.zScale);
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(this.tmpColor, 0, colors, (quadIndex * 4 + i) * 3, 3);
        }
        int offset = quadIndex * 12;
        coordinates[offset + 0] = (float)x - 0.5f;
        coordinates[offset + 1] = (float)y - 0.5f;
        coordinates[offset + 2] = value;
        coordinates[offset + 3] = (float)x + 0.5f;
        coordinates[offset + 4] = (float)y - 0.5f;
        coordinates[offset + 5] = value;
        coordinates[offset + 6] = (float)x + 0.5f;
        coordinates[offset + 7] = (float)y + 0.5f;
        coordinates[offset + 8] = value;
        coordinates[offset + 9] = (float)x - 0.5f;
        coordinates[offset + 10] = (float)y + 0.5f;
        coordinates[offset + 11] = value;
    }
}

