/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.network;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Text2D;
import java.awt.Color;
import java.awt.Font;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import sim.field.network.Edge;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.network.SimpleEdgePortrayal3D;
import sim.portrayal3d.network.SpatialNetwork3D;
import sim.util.Double3D;

public abstract class PrimitiveEdgePortrayal3D
extends SimpleEdgePortrayal3D {
    public static final double DEFAULT_RADIUS = 0.5;
    public static final double DEFAULT_HEIGHT = 2.0;
    Node edgeModelPrototype;
    double[] transformData = new double[16];
    Transform3D transform = new Transform3D();
    Appearance appearance;
    int DEFAULT_SHAPE = 0;
    boolean pickable = true;

    public PrimitiveEdgePortrayal3D(Node model, Appearance appearance, Color labelColor, Font labelFont) {
        super(null, null, labelColor, labelFont);
        this.transformData[12] = 0.0;
        this.transformData[13] = 0.0;
        this.transformData[14] = 0.0;
        this.transformData[15] = 1.0;
        if (appearance != null) {
            this.setAppearance(null, appearance);
        }
        this.init(model);
    }

    protected void init(Node model) {
        this.edgeModelPrototype = model;
    }

    @Override
    public TransformGroup getModel(Object object, TransformGroup j3dModel) {
        Transform3D trans = null;
        LocationWrapper wrapper = (LocationWrapper)object;
        Edge edge = (Edge)wrapper.getLocation();
        SpatialNetwork3D field = (SpatialNetwork3D)wrapper.fieldPortrayal.getField();
        Double3D secondPoint = field.getObjectLocation(edge.to());
        Double3D firstPoint = field.getObjectLocation(edge.from());
        this.startPoint[0] = firstPoint.x;
        this.startPoint[1] = firstPoint.y;
        this.startPoint[2] = firstPoint.z;
        this.endPoint[0] = secondPoint.x;
        this.endPoint[1] = secondPoint.y;
        this.endPoint[2] = secondPoint.z;
        if (this.showLabels) {
            trans = this.transformForOffset((firstPoint.x + secondPoint.x) / 2.0, (firstPoint.y + secondPoint.y) / 2.0, (firstPoint.z + secondPoint.z) / 2.0);
        }
        if (j3dModel == null) {
            j3dModel = new TransformGroup();
            j3dModel.setCapability(14);
            j3dModel.setCapability(12);
            TransformGroup tg = new TransformGroup(this.getTransform(this.startPoint, this.endPoint));
            tg.setCapability(18);
            tg.setCapability(12);
            Node edgeModelClone = this.edgeModelPrototype.cloneTree(true);
            tg.addChild(edgeModelClone);
            j3dModel.addChild((Node)tg);
            this.passWrapperToShapes(j3dModel, wrapper);
            if (this.showLabels) {
                String str = this.getLabel(edge);
                Text2D text = new Text2D(str, new Color3f(this.labelColor), this.labelFont.getFamily(), this.labelFont.getSize(), this.labelFont.getStyle());
                text.setRectangleScaleFactor((float)(this.labelScale * 0.2));
                OrientedShape3D o3d = new OrientedShape3D(text.getGeometry(), text.getAppearance(), 1, new Point3f(0.0f, 0.0f, 0.0f));
                o3d.setCapability(15);
                o3d.setCapability(13);
                o3d.clearCapabilityIsFrequent(15);
                o3d.clearCapabilityIsFrequent(13);
                TransformGroup o = new TransformGroup();
                o.setCapability(12);
                o.setCapability(17);
                o.setCapability(18);
                o.clearCapabilityIsFrequent(12);
                o.setTransform(trans);
                o.setUserData((Object)str);
                PrimitiveEdgePortrayal3D.clearPickableFlags((Node)o);
                o.addChild((Node)o3d);
                j3dModel.addChild((Node)o);
            }
        } else {
            TransformGroup tg0 = (TransformGroup)j3dModel.getChild(0);
            tg0.setTransform(this.getTransform(this.startPoint, this.endPoint));
            if (this.showLabels) {
                TransformGroup tg = (TransformGroup)j3dModel.getChild(1);
                String str = this.getLabel(edge);
                if (!tg.getUserData().equals(str)) {
                    Text2D text = new Text2D(str, new Color3f(this.labelColor), this.labelFont.getFamily(), this.labelFont.getSize(), this.labelFont.getStyle());
                    text.setRectangleScaleFactor((float)(this.labelScale * 0.2));
                    OrientedShape3D o3d = (OrientedShape3D)tg.getChild(0);
                    o3d.setGeometry(text.getGeometry());
                    o3d.setAppearance(text.getAppearance());
                    tg.setUserData((Object)str);
                }
                tg.setTransform(trans);
            }
        }
        return j3dModel;
    }

    Transform3D getTransform(double[] from, double[] to) {
        double fx = from[0];
        double fy = from[1];
        double fz = from[2];
        double vx = to[0] - fx;
        double vy = to[1] - fy;
        double vz = to[2] - fz;
        double vx2 = vx * vx;
        double vy2 = vy * vy;
        double vz2 = vz * vz;
        double vxz2 = vx2 + vz2;
        double v2 = vxz2 + vy2;
        double v = vxz2 == 0.0 ? Math.abs(vy) : Math.sqrt(v2);
        double halfVx = this.transformData[1] = vx / 2.0;
        double halfVy = this.transformData[5] = vy / 2.0;
        double halfVz = this.transformData[9] = vz / 2.0;
        this.transformData[3] = fx + halfVx;
        this.transformData[7] = fy + halfVy;
        this.transformData[11] = fz + halfVz;
        if (vxz2 != 0.0) {
            this.transformData[4] = -vx / v;
            this.transformData[6] = -vz / v;
            double vxz2v = v * vxz2;
            double vxvz = vx * vz;
            double a = (v - vy) / vxz2v;
            this.transformData[0] = 1.0 - vx2 * a;
            this.transformData[10] = 1.0 - vz2 * a;
            this.transformData[8] = this.transformData[2] = -vxvz * a;
        } else {
            this.transformData[4] = 0.0;
            this.transformData[6] = 0.0;
            this.transformData[2] = 0.0;
            this.transformData[8] = 0.0;
            this.transformData[0] = 1.0;
            this.transformData[10] = vy >= 0.0 ? 1.0 : -1.0;
        }
        this.transform.set(this.transformData);
        return this.transform;
    }

    public static void setShape3DFlags(Shape3D shape) {
        shape.setCapability(15);
        shape.setCapability(14);
        shape.setCapability(12);
        shape.setCapability(13);
        shape.clearCapabilityIsFrequent(14);
        shape.clearCapabilityIsFrequent(15);
        shape.clearCapabilityIsFrequent(12);
        shape.clearCapabilityIsFrequent(13);
    }

    protected Appearance getAppearance(TransformGroup j3dModel) {
        if (j3dModel == null) {
            Appearance a = new Appearance();
            PrimitiveEdgePortrayal3D.setAppearanceFlags(a);
            return a;
        }
        return this.getShape(j3dModel, this.DEFAULT_SHAPE).getAppearance();
    }

    protected void setAppearance(TransformGroup j3dModel, Appearance app) {
        if (j3dModel == null) {
            this.appearance = app;
        } else {
            int numShapes = this.numShapes();
            for (int i = 0; i < numShapes; ++i) {
                this.getShape(j3dModel, i).setAppearance(app);
            }
        }
    }

    protected abstract int numShapes();

    protected Shape3D getShape(TransformGroup j3dModel, int shapeIndex) {
        TransformGroup g = (TransformGroup)j3dModel.getChild(0);
        Primitive p = (Primitive)g.getChild(0);
        return p.getShape(shapeIndex);
    }

    public void setPickable(boolean val) {
        this.pickable = val;
    }

    void passWrapperToShapes(TransformGroup j3dModel, LocationWrapper wrapper) {
        if (j3dModel != null) {
            int numShapes = this.numShapes();
            for (int i = 0; i < numShapes; ++i) {
                Shape3D s = this.getShape(j3dModel, i);
                if (this.appearance != null) {
                    s.setAppearance(this.appearance);
                }
                if (this.pickable) {
                    PrimitiveEdgePortrayal3D.setPickableFlags(s);
                }
                s.setUserData((Object)wrapper);
            }
        }
    }
}

