/*
 * Decompiled with CFR 0.152.
 */
package sim.portrayal3d.simple;

import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import sim.portrayal.LocationWrapper;
import sim.portrayal3d.SimplePortrayal3D;

public abstract class PrimitivePortrayal3D
extends SimplePortrayal3D {
    Transform3D transform;
    Appearance appearance;
    protected Node group;
    static final int DEFAULT_SHAPE = 0;
    boolean pickable = true;

    public static void setShape3DFlags(Shape3D shape) {
        shape.setCapability(15);
        shape.setCapability(14);
        shape.setCapability(12);
        shape.setCapability(13);
        shape.clearCapabilityIsFrequent(14);
        shape.clearCapabilityIsFrequent(15);
        shape.clearCapabilityIsFrequent(12);
        shape.clearCapabilityIsFrequent(13);
    }

    protected Shape3D getShape(TransformGroup j3dModel, int shapeIndex) {
        TransformGroup n = j3dModel;
        while (n instanceof TransformGroup) {
            n = n.getChild(0);
        }
        Primitive p = (Primitive)n;
        return p.getShape(shapeIndex);
    }

    protected void setAppearance(TransformGroup j3dModel, Appearance app) {
        if (j3dModel == null) {
            this.appearance = app;
        } else {
            int numShapes = this.numShapes();
            for (int i = 0; i < numShapes; ++i) {
                this.getShape(j3dModel, i).setAppearance(app);
            }
        }
    }

    protected Appearance getAppearance(TransformGroup j3dModel) {
        if (j3dModel == null || this.numShapes() == 0) {
            Appearance a = new Appearance();
            PrimitivePortrayal3D.setAppearanceFlags(a);
            return a;
        }
        return this.getShape(j3dModel, 0).getAppearance();
    }

    public boolean setTransform(TransformGroup j3dModel, Transform3D transform) {
        if (j3dModel == null || transform == null) {
            this.transform = transform;
        } else {
            Node n = j3dModel.getChild(0);
            if (n instanceof TransformGroup) {
                TransformGroup g = (TransformGroup)j3dModel.getChild(0);
                g.setTransform(transform);
            }
        }
        return true;
    }

    public boolean setScale(TransformGroup j3dModel, double val) {
        if (this.transform != null || val != 1.0) {
            Transform3D tr = new Transform3D();
            tr.setScale((double)((float)val));
            return this.setTransform(j3dModel, tr);
        }
        return this.setTransform(j3dModel, this.transform);
    }

    protected abstract int numShapes();

    public void setPickable(boolean val) {
        this.pickable = val;
    }

    @Override
    public TransformGroup getModel(Object obj, TransformGroup j3dModel) {
        if (j3dModel == null) {
            j3dModel = new TransformGroup();
            j3dModel.setCapability(12);
            LocationWrapper pickI = new LocationWrapper(obj, null, this.getCurrentFieldPortrayal());
            Node g = this.group.cloneTree(true);
            if (this.transform != null) {
                TransformGroup tg = new TransformGroup();
                tg.setTransform(this.transform);
                tg.setCapability(17);
                tg.setCapability(18);
                tg.setCapability(12);
                tg.addChild(g);
                g = tg;
            }
            j3dModel.addChild(g);
            int numShapes = this.numShapes();
            for (int i = 0; i < numShapes; ++i) {
                Shape3D shape = this.getShape(j3dModel, i);
                shape.setAppearance(this.appearance);
                if (this.pickable) {
                    PrimitivePortrayal3D.setPickableFlags(shape);
                }
                shape.setUserData((Object)pickI);
            }
        }
        return j3dModel;
    }
}

