/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.io.Serializable;
import sim.util.Bag;

public class Heap
implements Serializable {
    private static final long serialVersionUID = 1L;
    Comparable[] keys = null;
    Object[] objects = null;
    int numElem = 0;

    public Heap() {
        this(new Comparable[0], new Object[0]);
    }

    public Heap(Comparable[] keys, Object[] objects) {
        if (keys.length != objects.length) {
            throw new IllegalArgumentException("keys and objects must be of the same length");
        }
        this.keys = keys;
        this.objects = objects;
        this.numElem = keys.length;
        this.buildHeap();
    }

    void buildHeap() {
        for (int i = this.numElem / 2; i >= 1; --i) {
            this.heapify(i, this.numElem);
        }
    }

    void heapify(int i, int heapsize) {
        Object[] objects = this.objects;
        Comparable[] keys = this.keys;
        while (true) {
            int l = 2 * i;
            int r = 2 * i + 1;
            int smallest = l <= heapsize && keys[l - 1].compareTo(keys[i - 1]) < 0 ? l : i;
            if (r <= heapsize && keys[r - 1].compareTo(keys[smallest - 1]) < 0) {
                smallest = r;
            }
            if (smallest == i) break;
            Comparable tempkey = keys[i - 1];
            keys[i - 1] = keys[smallest - 1];
            keys[smallest - 1] = tempkey;
            Object temp = objects[i - 1];
            objects[i - 1] = objects[smallest - 1];
            objects[smallest - 1] = temp;
            i = smallest;
        }
    }

    public Comparable getMinKey() {
        if (this.numElem == 0) {
            return null;
        }
        return this.keys[0];
    }

    Bag extractMin(Comparable comparable, Bag putInHere) {
        if (putInHere == null) {
            putInHere = new Bag();
        }
        Comparable comp;
        while ((comp = this.getMinKey()) != null && comparable.compareTo(comp) == 0) {
            putInHere.add(this.extractMin());
        }
        return putInHere;
    }

    public Bag extractMin(Bag putInHere) {
        Comparable min = this.getMinKey();
        if (min == null) {
            if (putInHere == null) {
                return new Bag(0);
            }
            return putInHere;
        }
        if (putInHere == null) {
            putInHere = new Bag();
        }
        putInHere.add(this.extractMin());
        return this.extractMin(min, putInHere);
    }

    public Object extractMin() {
        int numElem = this.numElem;
        Object[] objects = this.objects;
        Comparable[] keys = this.keys;
        if (numElem == 0) {
            return null;
        }
        keys[0] = keys[numElem - 1];
        keys[numElem - 1] = null;
        Object result = objects[0];
        objects[0] = objects[numElem - 1];
        objects[numElem - 1] = null;
        if (--numElem > 1) {
            this.heapify(1, numElem);
        }
        this.numElem = numElem;
        return result;
    }

    public void add(Object elem, Comparable key) {
        int i;
        int numElem = this.numElem;
        Object[] objects = this.objects;
        Comparable[] keys = this.keys;
        if (++numElem - 1 >= objects.length) {
            Object[] temp = new Object[objects.length * 2 + 1];
            System.arraycopy(objects, 0, temp, 0, objects.length);
            objects = temp;
            Comparable[] temptemp = new Comparable[keys.length * 2 + 1];
            System.arraycopy(keys, 0, temptemp, 0, keys.length);
            keys = temptemp;
            this.objects = objects;
            this.keys = keys;
        }
        if ((i = numElem) > 1) {
            while (i > 1 && key.compareTo(keys[i / 2 - 1]) < 0) {
                objects[i - 1] = objects[i / 2 - 1];
                keys[i - 1] = keys[i / 2 - 1];
                i /= 2;
            }
        }
        keys[i - 1] = key;
        objects[i - 1] = elem;
        this.numElem = numElem;
    }

    public boolean isEmpty() {
        return this.numElem == 0;
    }

    public void clear() {
        int len = this.numElem;
        Object[] objects = this.objects;
        Comparable[] keys = this.keys;
        for (int x = 0; x < len; ++x) {
            objects[x] = null;
            keys[x] = null;
        }
        this.numElem = 0;
    }

    public Heap merge(Heap other) {
        int n = this.numElem + other.numElem;
        Comparable[] combinedKeys = new Comparable[n];
        Object[] combinedObjects = new Object[n];
        System.arraycopy(this.keys, 0, combinedKeys, 0, this.numElem);
        System.arraycopy(other.keys, 0, combinedKeys, this.numElem, other.numElem);
        System.arraycopy(this.objects, 0, combinedObjects, 0, this.numElem);
        System.arraycopy(other.objects, 0, combinedObjects, this.numElem, other.numElem);
        return new Heap(combinedKeys, combinedObjects);
    }
}

