/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import sim.util.Interval;
import sim.util.Propertied;
import sim.util.Properties;
import sim.util.Proxiable;

public class SimpleProperties
extends Properties
implements Serializable {
    private static final long serialVersionUID = 1L;
    ArrayList getMethods = new ArrayList();
    ArrayList setMethods = new ArrayList();
    ArrayList domMethods = new ArrayList();
    ArrayList desMethods = new ArrayList();
    ArrayList hideMethods = new ArrayList();
    ArrayList nameMethods = new ArrayList();
    Properties auxillary = null;

    public SimpleProperties(Object o) {
        this(o, true, false, true);
    }

    public SimpleProperties(Object o, boolean includeSuperclasses, boolean includeGetClass) {
        this(o, includeSuperclasses, includeGetClass, true);
    }

    public SimpleProperties(Object o, boolean includeSuperclasses, boolean includeGetClass, boolean includeExtensions) {
        this.object = o;
        if (o != null && o instanceof Proxiable) {
            this.object = ((Proxiable)o).propertiesProxy();
        } else if (o != null && o instanceof Propertied) {
            this.auxillary = ((Propertied)o).properties();
        }
        this.generateProperties(includeSuperclasses, includeGetClass, includeExtensions);
    }

    void generateProperties(boolean includeSuperclasses, boolean includeGetClass, boolean includeExtensions) {
        if (this.object != null && this.auxillary == null) {
            try {
                Method meth;
                Class<?> c = this.object.getClass();
                if (this.object instanceof Long || this.object instanceof Integer || this.object instanceof Short || this.object instanceof Byte) {
                    meth = c.getMethod("longValue", new Class[0]);
                    this.getMethods.add(meth);
                    this.setMethods.add(null);
                    this.domMethods.add(null);
                    this.hideMethods.add(null);
                    this.desMethods.add(null);
                    this.nameMethods.add(null);
                } else if (this.object instanceof Number) {
                    meth = c.getMethod("doubleValue", new Class[0]);
                    this.getMethods.add(meth);
                    this.setMethods.add(null);
                    this.domMethods.add(null);
                    this.hideMethods.add(null);
                    this.desMethods.add(null);
                    this.nameMethods.add(null);
                }
                if (this.object instanceof Boolean) {
                    meth = c.getMethod("booleanValue", new Class[0]);
                    this.getMethods.add(meth);
                    this.setMethods.add(null);
                    this.domMethods.add(null);
                    this.hideMethods.add(null);
                    this.desMethods.add(null);
                    this.nameMethods.add(null);
                }
                if (this.object instanceof CharSequence) {
                    meth = c.getMethod("toString", new Class[0]);
                    this.getMethods.add(meth);
                    this.setMethods.add(null);
                    this.domMethods.add(null);
                    this.hideMethods.add(null);
                    this.desMethods.add(null);
                    this.nameMethods.add(null);
                }
                Method[] m = includeSuperclasses ? c.getMethods() : c.getDeclaredMethods();
                for (int x = 0; x < m.length; ++x) {
                    Interval interval;
                    Class<?> returnType;
                    if ("get".equals(m[x].getName()) || "is".equals(m[x].getName()) || !m[x].getName().startsWith("get") && !m[x].getName().startsWith("is")) continue;
                    int modifier = m[x].getModifiers();
                    if (!includeGetClass && m[x].getName().equals("getClass") || m[x].getParameterTypes().length != 0 || !Modifier.isPublic(modifier) || (returnType = m[x].getReturnType()) == Void.TYPE) continue;
                    this.getMethods.add(m[x]);
                    this.setMethods.add(this.getWriteProperty(m[x], c));
                    this.domMethods.add(this.getDomain(m[x], c, includeExtensions));
                    this.hideMethods.add(this.getHidden(m[x], c, includeExtensions));
                    this.desMethods.add(this.getDescription(m[x], c, includeExtensions));
                    this.nameMethods.add(this.getName(m[x], c, includeExtensions));
                    int lastIndex = this.domMethods.size() - 1;
                    Object domain = this.getDomain(lastIndex);
                    if (returnType == Float.TYPE || returnType == Double.TYPE) {
                        if (domain == null || !(domain instanceof Interval) || (interval = (Interval)domain).isDouble()) continue;
                        System.err.println("WARNING: Property is double or float valued, but the Interval provided for the property's domain is byte/short/integer/long valued: " + this.getName(lastIndex) + " on Object " + this.object);
                        this.domMethods.set(lastIndex, null);
                        continue;
                    }
                    if (returnType == Byte.TYPE || returnType == Short.TYPE || returnType == Integer.TYPE || returnType == Long.TYPE) {
                        if (domain == null || !(domain instanceof Interval) || !(interval = (Interval)domain).isDouble()) continue;
                        System.err.println("WARNING: Property is byte/short/integer/long valued, but the Interval provided for the property's domain is double or float valued: " + this.getName(lastIndex) + " on Object " + this.object);
                        this.domMethods.set(lastIndex, null);
                        continue;
                    }
                    if (domain == null || !(domain instanceof Interval)) continue;
                    System.err.println("WARNING: Property is not a basic number type, but an Interval was provided for the property's domain: " + this.getName(lastIndex) + " on Object " + this.object);
                    this.domMethods.set(lastIndex, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    Method getHidden(Method m, Class c, boolean includeExtensions) {
        if (!includeExtensions) {
            return null;
        }
        try {
            Method m2;
            if (m.getName().startsWith("get")) {
                Method m22 = c.getMethod("hide" + m.getName().substring(3), new Class[0]);
                if (m22.getReturnType() == Boolean.TYPE) {
                    return m22;
                }
            } else if (m.getName().startsWith("is") && (m2 = c.getMethod("hide" + m.getName().substring(2), new Class[0])).getReturnType() == Boolean.TYPE) {
                return m2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    Method getWriteProperty(Method m, Class c) {
        try {
            if (m.getName().startsWith("get")) {
                return c.getMethod("set" + m.getName().substring(3), m.getReturnType());
            }
            if (m.getName().startsWith("is")) {
                return c.getMethod("set" + m.getName().substring(2), m.getReturnType());
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    Method getDomain(Method m, Class c, boolean includeExtensions) {
        if (!includeExtensions) {
            return null;
        }
        try {
            if (m.getName().startsWith("get")) {
                return c.getMethod("dom" + m.getName().substring(3), new Class[0]);
            }
            if (m.getName().startsWith("is")) {
                return c.getMethod("dom" + m.getName().substring(2), new Class[0]);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    Method getDescription(Method m, Class c, boolean includeExtensions) {
        if (!includeExtensions) {
            return null;
        }
        try {
            if (m.getName().startsWith("get")) {
                return c.getMethod("des" + m.getName().substring(3), new Class[0]);
            }
            if (m.getName().startsWith("is")) {
                return c.getMethod("des" + m.getName().substring(2), new Class[0]);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    Method getName(Method m, Class c, boolean includeExtensions) {
        if (!includeExtensions) {
            return null;
        }
        try {
            if (m.getName().startsWith("get")) {
                return c.getMethod("name" + m.getName().substring(3), new Class[0]);
            }
            if (m.getName().startsWith("is")) {
                return c.getMethod("name" + m.getName().substring(2), new Class[0]);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isVolatile() {
        if (this.auxillary != null) {
            return this.auxillary.isVolatile();
        }
        return false;
    }

    @Override
    public int numProperties() {
        if (this.auxillary != null) {
            return this.auxillary.numProperties();
        }
        return this.getMethods.size();
    }

    @Override
    public String getName(int index) {
        if (this.auxillary != null) {
            return this.auxillary.getName(index);
        }
        if (index < 0 || index >= this.numProperties()) {
            return null;
        }
        try {
            if (this.nameMethods.get(index) != null) {
                return (String)((Method)this.nameMethods.get(index)).invoke(this.object, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String name = ((Method)this.getMethods.get(index)).getName();
        if (name.startsWith("is")) {
            return name.substring(2);
        }
        if (name.equals("longValue")) {
            return "Value";
        }
        if (name.equals("doubleValue")) {
            return "Value";
        }
        if (name.equals("booleanValue")) {
            return "Value";
        }
        if (name.equals("toString")) {
            return "Value";
        }
        return name.substring(3);
    }

    @Override
    public boolean isReadWrite(int index) {
        if (this.auxillary != null) {
            return this.auxillary.isReadWrite(index);
        }
        if (index < 0 || index >= this.numProperties()) {
            return false;
        }
        if (this.isComposite(index)) {
            return false;
        }
        return this.setMethods.get(index) != null;
    }

    @Override
    public Class getType(int index) {
        if (this.auxillary != null) {
            return this.auxillary.getType(index);
        }
        if (index < 0 || index >= this.numProperties()) {
            return null;
        }
        Class<?> returnType = ((Method)this.getMethods.get(index)).getReturnType();
        return this.getTypeConversion(returnType);
    }

    @Override
    public Object getValue(int index) {
        if (this.auxillary != null) {
            return this.auxillary.getValue(index);
        }
        if (index < 0 || index >= this.numProperties()) {
            return null;
        }
        try {
            return ((Method)this.getMethods.get(index)).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Object _setValue(int index, Object value) {
        if (this.auxillary != null) {
            return this.auxillary.setValue(index, value);
        }
        try {
            if (this.setMethods.get(index) == null) {
                return null;
            }
            ((Method)this.setMethods.get(index)).invoke(this.object, value);
            return this.getValue(index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getDescription(int index) {
        if (this.auxillary != null) {
            return this.auxillary.getDescription(index);
        }
        if (index < 0 || index >= this.numProperties()) {
            return null;
        }
        try {
            if (this.desMethods.get(index) == null) {
                return null;
            }
            return (String)((Method)this.desMethods.get(index)).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getDomain(int index) {
        if (this.auxillary != null) {
            return this.auxillary.getDomain(index);
        }
        if (index < 0 || index >= this.numProperties()) {
            return null;
        }
        try {
            if (this.domMethods.get(index) == null) {
                return null;
            }
            return ((Method)this.domMethods.get(index)).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isHidden(int index) {
        if (this.auxillary != null) {
            return this.auxillary.isHidden(index);
        }
        if (index < 0 || index >= this.numProperties()) {
            return false;
        }
        try {
            if (this.hideMethods.get(index) == null) {
                return false;
            }
            return (Boolean)((Method)this.hideMethods.get(index)).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

