/*
 * Decompiled with CFR 0.152.
 */
package sim.util;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.ImageIcon;
import sun.awt.image.ToolkitImage;

public class TableLoader {
    static String tokenizeString(InputStream stream) throws IOException {
        return TableLoader.tokenizeString(stream, false);
    }

    static String tokenizeString(InputStream stream, boolean oneChar) throws IOException {
        int c;
        int EOF = -1;
        StringBuilder b = new StringBuilder();
        boolean inComment = false;
        while (true) {
            if ((c = stream.read()) == -1) {
                throw new IOException("Stream ended prematurely, before table reading was completed.");
            }
            if (inComment) {
                if (c != 13 && c != 10) continue;
                inComment = false;
                continue;
            }
            if (Character.isWhitespace((char)c)) continue;
            if (c != 35) break;
            inComment = true;
        }
        b.append((char)c);
        if (oneChar) {
            return b.toString();
        }
        while ((c = stream.read()) != -1) {
            if (c == 35) {
                while ((c = stream.read()) != -1 && c != 13 && c != 10) {
                }
                continue;
            }
            if (Character.isWhitespace((char)c)) break;
            b.append((char)c);
        }
        return b.toString();
    }

    static int tokenizeInt(InputStream stream) throws IOException {
        return Integer.parseInt(TableLoader.tokenizeString(stream));
    }

    public static int[][] loadPNMFile(InputStream str, boolean flipY) throws IOException {
        int[][] vals = TableLoader.loadPNMFile(str);
        if (flipY) {
            for (int i = 0; i < vals.length; ++i) {
                int height = vals[i].length;
                for (int j = 0; j < height / 2; ++j) {
                    int temp = vals[i][j];
                    vals[i][j] = vals[i][height - j + 1];
                    vals[i][height - j + 1] = temp;
                }
            }
        }
        return vals;
    }

    public static int[][] loadPNMFile(InputStream str) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(str);
        String type = TableLoader.tokenizeString(stream);
        if (type.equals("P1")) {
            return TableLoader.loadPlainPBM(stream);
        }
        if (type.equals("P2")) {
            return TableLoader.loadPlainPGM(stream);
        }
        if (type.equals("P4")) {
            return TableLoader.loadRawPBM(stream);
        }
        if (type.equals("P5")) {
            return TableLoader.loadRawPGM(stream);
        }
        throw new IOException("Not a viable PBM or PGM stream");
    }

    static int[][] loadPlainPGM(InputStream stream) throws IOException {
        int width = TableLoader.tokenizeInt(stream);
        int height = TableLoader.tokenizeInt(stream);
        int maxGray = TableLoader.tokenizeInt(stream);
        if (width < 0) {
            throw new IOException("Invalid width in PGM: " + width);
        }
        if (height < 0) {
            throw new IOException("Invalid height in PGM: " + height);
        }
        if (maxGray <= 0) {
            throw new IOException("Invalid maximum value in PGM: " + maxGray);
        }
        int[][] field = new int[width][height];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                field[j][i] = TableLoader.tokenizeInt(stream);
            }
        }
        return field;
    }

    static int[][] loadRawPGM(InputStream stream) throws IOException {
        int width = TableLoader.tokenizeInt(stream);
        int height = TableLoader.tokenizeInt(stream);
        int maxVal = TableLoader.tokenizeInt(stream);
        if (width < 0) {
            throw new IOException("Invalid width: " + width);
        }
        if (height < 0) {
            throw new IOException("Invalid height: " + height);
        }
        if (maxVal <= 0) {
            throw new IOException("Invalid maximum value: " + maxVal);
        }
        int[][] field = new int[width][height];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                field[j][i] = maxVal < 256 ? stream.read() : (maxVal < 65536 ? stream.read() << 8 & stream.read() : (maxVal < 0x1000000 ? stream.read() << 16 & stream.read() << 8 & stream.read() : stream.read() << 24 & stream.read() << 16 & stream.read() << 8 & stream.read()));
            }
        }
        return field;
    }

    static int[][] loadPlainPBM(InputStream stream) throws IOException {
        int width = TableLoader.tokenizeInt(stream);
        int height = TableLoader.tokenizeInt(stream);
        if (width < 0) {
            throw new IOException("Invalid width in PBM: " + width);
        }
        if (height < 0) {
            throw new IOException("Invalid height in PBM: " + height);
        }
        int[][] field = new int[width][height];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                String s = TableLoader.tokenizeString(stream, true);
                if (s.equals("0")) {
                    field[j][i] = 0;
                    continue;
                }
                if (s.equals("1")) {
                    field[j][i] = 1;
                    continue;
                }
                throw new IOException("Invalid byte data in PBM");
            }
        }
        return field;
    }

    static int[][] loadRawPBM(InputStream stream) throws IOException {
        int width = TableLoader.tokenizeInt(stream);
        int height = TableLoader.tokenizeInt(stream);
        if (width < 0) {
            throw new IOException("Invalid width in PBM: " + width);
        }
        if (height < 0) {
            throw new IOException("Invalid height in PBM: " + height);
        }
        int[][] field = new int[width][height];
        for (int i = 0; i < height; ++i) {
            int data = 0;
            int count = 0;
            for (int j = 0; j < width; ++j) {
                if (count == 0) {
                    data = stream.read();
                    count = 8;
                }
                field[j][i] = data >> --count & 1;
            }
        }
        return field;
    }

    public static double[][] loadTextFile(InputStream str, boolean flipY) throws RuntimeException, IOException {
        double[][] vals = TableLoader.loadTextFile(str);
        if (flipY) {
            for (int i = 0; i < vals.length; ++i) {
                int height = vals[i].length;
                for (int j = 0; j < height / 2; ++j) {
                    double temp = vals[i][j];
                    vals[i][j] = vals[i][height - j + 1];
                    vals[i][height - j + 1] = temp;
                }
            }
        }
        return vals;
    }

    public static double[][] loadTextFile(InputStream stream) throws IOException {
        Scanner scan = new Scanner(stream);
        ArrayList<double[]> rows = new ArrayList<double[]>();
        int width = -1;
        while (scan.hasNextLine()) {
            Scanner rowScan;
            String srow = scan.nextLine().trim();
            if (srow.length() <= 0) continue;
            int w = 0;
            if (width == -1) {
                ArrayList<Double> firstRow = new ArrayList<Double>();
                rowScan = new Scanner(new StringReader(srow));
                while (rowScan.hasNextDouble()) {
                    firstRow.add(new Double(rowScan.nextDouble()));
                    ++w;
                }
                width = w;
                double[] row = new double[width];
                for (int i = 0; i < width; ++i) {
                    row[i] = (Double)firstRow.get(i);
                }
                rows.add(row);
                continue;
            }
            double[] row = new double[width];
            rowScan = new Scanner(new StringReader(srow));
            while (rowScan.hasNextDouble()) {
                if (w == width) {
                    throw new IOException("Row lengths do not match in text file");
                }
                row[w] = rowScan.nextDouble();
                ++w;
            }
            if (w < width) {
                throw new IOException("Row lengths do not match in text file");
            }
            rows.add(row);
        }
        if (width == -1) {
            return new double[0][0];
        }
        double[][] fieldTransposed = new double[rows.size()][];
        for (int i = 0; i < rows.size(); ++i) {
            fieldTransposed[i] = (double[])rows.get(i);
        }
        double[][] field = new double[width][fieldTransposed.length];
        for (int i = 0; i < field.length; ++i) {
            for (int j = 0; j < field[i].length; ++j) {
                field[i][j] = fieldTransposed[j][i];
            }
        }
        return field;
    }

    public static int[][] loadGIFFile(InputStream str, boolean flipY) throws IOException {
        return TableLoader.loadPNGFile(str, flipY);
    }

    public static int[][] loadGIFFile(InputStream str) throws IOException {
        return TableLoader.loadPNGFile(str);
    }

    public static int[][] loadPNGFile(InputStream str, boolean flipY) throws IOException {
        int[][] vals = TableLoader.loadPNGFile(str);
        if (flipY) {
            for (int i = 0; i < vals.length; ++i) {
                int height = vals[i].length;
                for (int j = 0; j < height / 2; ++j) {
                    int temp = vals[i][j];
                    vals[i][j] = vals[i][height - j + 1];
                    vals[i][height - j + 1] = temp;
                }
            }
        }
        return vals;
    }

    public static int[][] loadPNGFile(InputStream str) throws IOException {
        byte[] buffer;
        int len;
        BufferedInputStream stream = new BufferedInputStream(str);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int count = 0;
        while ((len = stream.read(buffer = new byte[262144])) > 0) {
            if (len < buffer.length) {
                byte[] buf2 = new byte[len];
                System.arraycopy(buffer, 0, buf2, 0, len);
                buffer = buf2;
            }
            count += len;
            list.add(buffer);
        }
        byte[] data = new byte[count];
        int cur = 0;
        for (int i = 0; i < list.size(); ++i) {
            byte[] b = (byte[])list.get(i);
            System.arraycopy(b, 0, data, cur, b.length);
            cur += b.length;
        }
        BufferedImage image = ((ToolkitImage)new ImageIcon(data).getImage()).getBufferedImage();
        int type = image.getType();
        if (type == 12 || type == 10) {
            int w = image.getWidth();
            int h = image.getHeight();
            int[][] result = new int[w][h];
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    result[i][j] = image.getRGB(i, j) & 0xFF;
                }
            }
            return result;
        }
        if (type == 13) {
            WritableRaster raster = image.getRaster();
            if (raster.getTransferType() != 0) {
                throw new IOException("Input Stream must contain an image with byte data if indexed.");
            }
            byte[] pixel = new byte[1];
            int w = image.getWidth();
            int h = image.getHeight();
            int[][] result = new int[w][h];
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    result[i][j] = ((byte[])raster.getDataElements(i, j, pixel))[0];
                    if (result[i][j] >= 0) continue;
                    int[] nArray = result[i];
                    int n = j;
                    nArray[n] = nArray[n] + 256;
                }
            }
            return result;
        }
        throw new IOException("Input Stream must contain a binary, byte-sized grayscale, or byte-sized indexed color scheme: " + image);
    }

    public static int[][] convertToIntArray(double[][] vals) {
        int[][] ret = new int[vals.length][];
        for (int i = 0; i < vals.length; ++i) {
            double[] valsi = vals[i];
            ret[i] = new int[valsi.length];
            int[] reti = ret[i];
            for (int j = 0; j < valsi.length; ++j) {
                int a = (int)valsi[j];
                if ((double)a != valsi[j]) {
                    return null;
                }
                reti[j] = a;
            }
        }
        return ret;
    }

    public static double[][] convertToDoubleArray(int[][] vals) {
        double[][] ret = new double[vals.length][];
        for (int i = 0; i < vals.length; ++i) {
            int[] valsi = vals[i];
            ret[i] = new double[valsi.length];
            double[] reti = ret[i];
            for (int j = 0; j < valsi.length; ++j) {
                reti[j] = valsi[j];
            }
        }
        return ret;
    }

    public static long[][] convertToLongArray(double[][] vals) {
        long[][] ret = new long[vals.length][];
        for (int i = 0; i < vals.length; ++i) {
            double[] valsi = vals[i];
            ret[i] = new long[valsi.length];
            long[] reti = ret[i];
            for (int j = 0; j < valsi.length; ++j) {
                long a = (long)valsi[j];
                if ((double)a != valsi[j]) {
                    return null;
                }
                reti[j] = a;
            }
        }
        return ret;
    }

    public static long[][] convertToLongArray(int[][] vals) {
        long[][] ret = new long[vals.length][];
        for (int i = 0; i < vals.length; ++i) {
            int[] valsi = vals[i];
            ret[i] = new long[valsi.length];
            long[] reti = ret[i];
            for (int j = 0; j < valsi.length; ++j) {
                reti[j] = valsi[j];
            }
        }
        return ret;
    }
}

