/*
 * Decompiled with CFR 0.152.
 */
package sim.util.distribution;

import ec.util.MersenneTwisterFast;
import java.io.Serializable;

public class Distributions
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected Distributions() {
        throw new RuntimeException("Non instantiable");
    }

    public static double geometricPdf(int k, double p) {
        if (k < 0) {
            throw new IllegalArgumentException();
        }
        return p * Math.pow(1.0 - p, k);
    }

    public static double nextBurr1(double r, int nr, MersenneTwisterFast randomGenerator) {
        double y = Math.exp(Math.log(randomGenerator.nextDouble()) / r);
        switch (nr) {
            case 2: {
                return -Math.log(1.0 / y - 1.0);
            }
            case 7: {
                return Math.log(2.0 * y / (2.0 - 2.0 * y)) / 2.0;
            }
            case 8: {
                return Math.log(Math.tan(y * Math.PI / 2.0));
            }
            case 10: {
                return Math.sqrt(-Math.log(1.0 - y));
            }
        }
        return 0.0;
    }

    public static double nextBurr2(double r, double k, int nr, MersenneTwisterFast randomGenerator) {
        double u = randomGenerator.nextDouble();
        double y = Math.exp(-Math.log(u) / r) - 1.0;
        switch (nr) {
            case 3: {
                return Math.exp(-Math.log(y) / k);
            }
            case 4: {
                y = Math.exp(k * Math.log(y)) + 1.0;
                y = k / y;
                return y;
            }
            case 5: {
                y = Math.atan(-Math.log(y / k));
                return y;
            }
            case 6: {
                y = -Math.log(y / k) / r;
                y = Math.log(y + Math.sqrt(y * y + 1.0));
                return y;
            }
            case 9: {
                y = 1.0 + 2.0 * u / (k * (1.0 - u));
                y = Math.exp(Math.log(y) / r) - 1.0;
                return Math.log(y);
            }
            case 12: {
                return Math.exp(Math.log(y) / k);
            }
        }
        return 0.0;
    }

    public static double nextCauchy(MersenneTwisterFast randomGenerator) {
        return Math.tan(Math.PI * randomGenerator.nextDouble());
    }

    public static double nextErlang(double variance, double mean, MersenneTwisterFast randomGenerator) {
        int k = (int)(mean * mean / variance + 0.5);
        k = k > 0 ? k : 1;
        double a = (double)k / mean;
        double prod = 1.0;
        for (int i = 0; i < k; ++i) {
            prod *= randomGenerator.nextDouble();
        }
        return -Math.log(prod) / a;
    }

    public static int nextGeometric(double p, MersenneTwisterFast randomGenerator) {
        double u = randomGenerator.nextDouble();
        return (int)(Math.log(u) / Math.log(1.0 - p));
    }

    public static double nextLambda(double l3, double l4, MersenneTwisterFast randomGenerator) {
        double l_sign = l3 < 0.0 || l4 < 0.0 ? -1.0 : 1.0;
        double u = randomGenerator.nextDouble();
        double x = l_sign * (Math.exp(Math.log(u) * l3) - Math.exp(Math.log(1.0 - u) * l4));
        return x;
    }

    public static double nextLaplace(MersenneTwisterFast randomGenerator) {
        double u = randomGenerator.nextDouble();
        if ((u = u + u - 1.0) > 0.0) {
            return -Math.log(1.0 - u);
        }
        return Math.log(1.0 + u);
    }

    public static double nextLogistic(MersenneTwisterFast randomGenerator) {
        double u = randomGenerator.nextDouble();
        return -Math.log(1.0 / u - 1.0);
    }

    public static double nextPowLaw(double alpha, double cut, MersenneTwisterFast randomGenerator) {
        return cut * Math.pow(randomGenerator.nextDouble(), 1.0 / (alpha + 1.0));
    }

    public static double nextTriangular(MersenneTwisterFast randomGenerator) {
        double u = randomGenerator.nextDouble();
        if (u <= 0.5) {
            return Math.sqrt(2.0 * u) - 1.0;
        }
        return 1.0 - Math.sqrt(2.0 * (1.0 - u));
    }

    public static double nextWeibull(double alpha, double beta, MersenneTwisterFast randomGenerator) {
        return Math.pow(beta * -Math.log(1.0 - randomGenerator.nextDouble()), 1.0 / alpha);
    }

    public static int nextZipfInt(double z, MersenneTwisterFast randomGenerator) {
        double t;
        double u;
        double v;
        double b = Math.pow(2.0, z - 1.0);
        double constant = -1.0 / (z - 1.0);
        int result = 0;
        do {
            u = randomGenerator.nextDouble();
        } while (!((v = randomGenerator.nextDouble()) * (double)(result = (int)Math.floor(Math.pow(u, constant))) * ((t = Math.pow(1.0 + 1.0 / (double)result, z - 1.0)) - 1.0) / (b - 1.0) <= t / b));
        return result;
    }
}

