/*
 * Decompiled with CFR 0.152.
 */
package sim.util.distribution;

import ec.util.MersenneTwisterFast;
import sim.util.distribution.AbstractContinousDistribution;

public class Exponential
extends AbstractContinousDistribution {
    private static final long serialVersionUID = 1L;
    protected double lambda;

    public Exponential(double lambda, MersenneTwisterFast randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(lambda);
    }

    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-x * this.lambda);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.lambda);
    }

    public double nextDouble(double lambda) {
        return -Math.log(this.randomGenerator.nextDouble()) / lambda;
    }

    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.lambda * Math.exp(-x * this.lambda);
    }

    public void setState(double lambda) {
        this.lambda = lambda;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.lambda + ")";
    }
}

