/*
 * Decompiled with CFR 0.152.
 */
package sim.util.distribution;

import ec.util.MersenneTwisterFast;
import sim.util.distribution.AbstractDiscreteDistribution;

public class Zeta
extends AbstractDiscreteDistribution {
    private static final long serialVersionUID = 1L;
    protected double ro;
    protected double pk;
    protected double c;
    protected double d;
    protected double ro_prev = -1.0;
    protected double pk_prev = -1.0;
    protected double maxlongint = 9.223372036854776E18;

    public Zeta(double ro, double pk, MersenneTwisterFast randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(ro, pk);
    }

    protected long generateZeta(double ro, double pk, MersenneTwisterFast randomGenerator) {
        long k;
        if (ro != this.ro_prev || pk != this.pk_prev) {
            this.ro_prev = ro;
            this.pk_prev = pk;
            if (ro < pk) {
                this.c = pk - 0.5;
                this.d = 0.0;
            } else {
                this.c = ro - 0.5;
                this.d = (1.0 + ro) * Math.log((1.0 + pk) / (1.0 + ro));
            }
        }
        while (true) {
            double u = randomGenerator.nextDouble();
            double v = randomGenerator.nextDouble();
            double x = (this.c + 0.5) * Math.exp(-Math.log(u) / ro) - this.c;
            if (x <= 0.5 || x >= this.maxlongint) continue;
            k = (int)(x + 0.5);
            double e = -Math.log(v);
            if (!(e < (1.0 + ro) * Math.log(((double)k + pk) / (x + this.c)) - this.d)) break;
        }
        return k;
    }

    @Override
    public int nextInt() {
        return (int)this.generateZeta(this.ro, this.pk, this.randomGenerator);
    }

    public void setState(double ro, double pk) {
        this.ro = ro;
        this.pk = pk;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.ro + "," + this.pk + ")";
    }
}

