/*
 * Decompiled with CFR 0.152.
 */
package sim.util.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;

public class MiniHistogram
extends JComponent {
    static JLabel DEFAULT_SIZE_COMPARISON = new JLabel("X");
    double[] buckets;
    String[] labels;
    MouseMotionAdapter motionAdapter = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent event) {
            String s = null;
            if (MiniHistogram.this.buckets != null) {
                int x = (int)((double)(event.getX() * MiniHistogram.this.buckets.length) / (double)MiniHistogram.this.getBounds().width);
                s = MiniHistogram.this.labels != null && x < MiniHistogram.this.labels.length ? "<html><font size=\"-1\" face=\"" + MiniHistogram.this.getFont().getFamily() + "\">" + "Bucket: " + x + "<br>Range: " + MiniHistogram.this.labels[x] + "<br>Value: " + MiniHistogram.this.buckets[x] + "</font></html>" : (MiniHistogram.this.buckets != null && MiniHistogram.this.buckets.length != 0 ? "<html><font size=\"-1\" face=\"" + MiniHistogram.this.getFont().getFamily() + "\">" + "Bucket: " + x + "<br>>Value: " + MiniHistogram.this.buckets[x] + "</font></html>" : null);
            }
            if (s != null && !s.equalsIgnoreCase(MiniHistogram.this.getToolTipText())) {
                MiniHistogram.this.setToolTipText(s);
            }
        }
    };
    MouseAdapter adapter = new MouseAdapter(){
        int initialDelay;
        int dismissDelay;
        int reshowDelay;

        @Override
        public void mouseEntered(MouseEvent event) {
            this.initialDelay = ToolTipManager.sharedInstance().getInitialDelay();
            ToolTipManager.sharedInstance().setInitialDelay(0);
            this.dismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            this.reshowDelay = ToolTipManager.sharedInstance().getReshowDelay();
            ToolTipManager.sharedInstance().setReshowDelay(0);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            ToolTipManager.sharedInstance().setInitialDelay(this.initialDelay);
            ToolTipManager.sharedInstance().setDismissDelay(this.dismissDelay);
            ToolTipManager.sharedInstance().setReshowDelay(this.reshowDelay);
        }
    };

    public MiniHistogram() {
        this.setBuckets(new double[0]);
        this.addMouseListener(this.adapter);
        this.addMouseMotionListener(this.motionAdapter);
        this.setBackground(DEFAULT_SIZE_COMPARISON.getBackground());
    }

    public MiniHistogram(double[] buckets, String[] labels) {
        this();
        this.setBucketsAndLabels(buckets, labels);
        this.setBackground(DEFAULT_SIZE_COMPARISON.getBackground());
        this.setOpaque(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return DEFAULT_SIZE_COMPARISON.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return DEFAULT_SIZE_COMPARISON.getMinimumSize();
    }

    public void setBuckets(double[] buckets) {
        if (buckets == null) {
            buckets = new double[]{};
        }
        this.buckets = buckets;
        this.repaint();
    }

    public void setBucketLabels(String[] labels) {
        this.labels = labels;
    }

    public void setBucketsAndLabels(double[] buckets, String[] labels) {
        this.setBuckets(buckets);
        this.setBucketLabels(labels);
    }

    @Override
    public synchronized void paintComponent(Graphics graphics) {
        int i;
        int len = 0;
        if (this.buckets != null) {
            len = this.buckets.length;
        }
        if (len == 0) {
            return;
        }
        Rectangle bounds = this.getBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, bounds.width, bounds.height);
        int height = bounds.height - 2;
        if (height <= 0) {
            return;
        }
        graphics.setColor(this.getForeground());
        double maxbucket = this.buckets[0];
        double minbucket = this.buckets[0];
        for (i = 1; i < len; ++i) {
            if (this.buckets[i] < minbucket) {
                minbucket = this.buckets[i];
            }
            if (!(this.buckets[i] > maxbucket)) continue;
            maxbucket = this.buckets[i];
        }
        if (maxbucket == minbucket) {
            graphics.fillRect(0, 0, bounds.width, height);
            return;
        }
        for (i = 0; i < len; ++i) {
            int x0 = (int)((double)bounds.width / (double)len * (double)i);
            int x1 = (int)((double)bounds.width / (double)len * (double)(i + 1));
            int y0 = 0;
            int y1 = this.buckets[i] == Double.POSITIVE_INFINITY ? height : (this.buckets[i] != this.buckets[i] ? 0 : (int)((double)height * ((this.buckets[i] - minbucket) / (maxbucket - minbucket))));
            y0 = height - y0;
            y1 = height - y1;
            graphics.fillRect(x0 + 1, y1 + 1, x1 - x0 + 1, y0 - y1 + 1);
        }
    }

    public static String[] makeBucketLabels(int numBuckets, double min, double max, boolean logScale) {
        String[] s = new String[numBuckets];
        if (min > max) {
            double tmp = min;
            min = max;
            max = tmp;
        } else {
            if (min == max) {
                s[0] = "[" + min + "..." + max + "]";
                for (int x = 1; x < s.length; ++x) {
                    s[x] = "";
                }
                return s;
            }
            if (logScale) {
                min = Math.log(min);
                max = Math.log(max);
                for (int x = 0; x < s.length; ++x) {
                    s[x] = "[" + Math.exp((double)x / (double)numBuckets * (max - min) + min) + "..." + Math.exp((double)(x + 1) / (double)numBuckets * (max - min) + min) + (x == s.length - 1 ? "]" : ")");
                }
            } else {
                for (int x = 0; x < s.length; ++x) {
                    s[x] = "[" + ((double)x / (double)numBuckets * (max - min) + min) + "..." + ((double)(x + 1) / (double)numBuckets * (max - min) + min) + (x == s.length - 1 ? "]" : ")");
                }
            }
        }
        return s;
    }

    public static double minimum(double[] vals) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < vals.length; ++i) {
            if (!(min > vals[i])) continue;
            min = vals[i];
        }
        return min;
    }

    public static double maximum(double[] vals) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vals.length; ++i) {
            if (!(max < vals[i])) continue;
            max = vals[i];
        }
        return max;
    }

    public static double[] makeBuckets(double[] vals, int numBuckets, double min, double max, boolean logScale) {
        int x;
        double[] b = new double[numBuckets];
        if (vals == null || numBuckets == 0) {
            return b;
        }
        if (logScale) {
            min = Math.log(min);
            max = Math.log(max);
        }
        if (min > max) {
            double tmp = min;
            min = max;
            max = tmp;
        } else if (min == max) {
            b[0] = b[0] + (double)vals.length;
            return b;
        }
        int count = 0;
        for (x = 0; x < vals.length; ++x) {
            double v = vals[x];
            if (logScale) {
                if (v < 0.0) continue;
                v = Math.log(v);
            }
            if (v < min || v > max) continue;
            int bucketnum = (int)((v - min) * (double)numBuckets / (max - min));
            if (bucketnum >= numBuckets) {
                bucketnum = numBuckets - 1;
            }
            int n = bucketnum;
            b[n] = b[n] + 1.0;
            ++count;
        }
        if (count != 0) {
            x = 0;
            while (x < b.length) {
                int n = x++;
                b[n] = b[n] / (double)count;
            }
        }
        return b;
    }
}

