/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.SeriesChangeListener;
import sim.util.gui.LabelledList;
import sim.util.gui.PropertyField;
import sim.util.media.chart.BarChartSeriesAttributes;
import sim.util.media.chart.PieChartGenerator;
import sim.util.media.chart.SeriesAttributes;

public class BarChartGenerator
extends PieChartGenerator {
    PropertyField xLabel;
    PropertyField yLabel;
    BarRenderer barRenderer;
    StackedBarRenderer stackedBarRenderer;
    StackedBarRenderer percentageRenderer;
    boolean hasgridlines = false;
    boolean ishorizontal = false;
    public static final int MAXIMUM_BAR_CHART_ITEMS = 20;
    final DefaultCategoryDataset emptyDataset = new DefaultCategoryDataset();

    public void setYAxisLabel(String val) {
        CategoryPlot xyplot = (CategoryPlot)this.chart.getPlot();
        xyplot.getRangeAxis().setLabel(val);
        xyplot.axisChanged(new AxisChangeEvent((Axis)xyplot.getRangeAxis()));
        this.yLabel.setValue(val);
    }

    public String getYAxisLabel() {
        return ((CategoryPlot)this.chart.getPlot()).getRangeAxis().getLabel();
    }

    public void setXAxisLabel(String val) {
        CategoryPlot xyplot = (CategoryPlot)this.chart.getPlot();
        xyplot.getDomainAxis().setLabel(val);
        xyplot.axisChanged(new AxisChangeEvent((Axis)xyplot.getDomainAxis()));
        this.xLabel.setValue(val);
    }

    public String getXAxisLabel() {
        return ((CategoryPlot)this.chart.getPlot()).getDomainAxis().getLabel();
    }

    BarRenderer getBarRenderer() {
        return this.barRenderer;
    }

    BarRenderer getStackedBarRenderer() {
        return this.stackedBarRenderer;
    }

    BarRenderer getPercentageRenderer() {
        return this.percentageRenderer;
    }

    void reviseRenderer(BarRenderer renderer) {
        renderer.setShadowVisible(false);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setBaseOutlineStroke((Stroke)new BasicStroke(2.0f));
        renderer.setDrawBarOutline(true);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{0}", NumberFormat.getInstance()));
        renderer.setBaseItemLabelsVisible(true);
    }

    @Override
    protected void buildGlobalAttributes(LabelledList list) {
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setDomainGridlinePaint((Paint)new Color(200, 200, 200));
        plot.setRangeGridlinePaint((Paint)new Color(200, 200, 200));
        this.barRenderer = new BarRenderer();
        this.reviseRenderer(this.barRenderer);
        this.stackedBarRenderer = new StackedBarRenderer(false);
        this.reviseRenderer((BarRenderer)this.stackedBarRenderer);
        this.percentageRenderer = new StackedBarRenderer(true);
        this.reviseRenderer((BarRenderer)this.percentageRenderer);
        plot.setRenderer((CategoryItemRenderer)this.barRenderer);
        this.xLabel = new PropertyField(){

            @Override
            public String newValue(String newValue) {
                BarChartGenerator.this.setXAxisLabel(newValue);
                BarChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.xLabel.setValue(this.getXAxisLabel());
        list.add((Component)new JLabel("X Label"), (Component)this.xLabel);
        this.yLabel = new PropertyField(){

            @Override
            public String newValue(String newValue) {
                BarChartGenerator.this.setYAxisLabel(newValue);
                BarChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.yLabel.setValue(this.getYAxisLabel());
        list.add((Component)new JLabel("Y Label"), (Component)this.yLabel);
        JCheckBox gridlines = new JCheckBox();
        gridlines.setSelected(false);
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BarChartGenerator.this.hasgridlines = e.getStateChange() == 1;
                BarChartGenerator.this.updateGridLines();
            }
        };
        gridlines.addItemListener(il);
        list.add((Component)new JLabel("Grid Lines"), (Component)gridlines);
        JCheckBox labels = new JCheckBox();
        labels.setSelected(true);
        il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BarChartGenerator.this.getBarRenderer().setBaseItemLabelsVisible(true);
                    BarChartGenerator.this.getStackedBarRenderer().setBaseItemLabelsVisible(true);
                    BarChartGenerator.this.getPercentageRenderer().setBaseItemLabelsVisible(true);
                } else {
                    BarChartGenerator.this.getBarRenderer().setBaseItemLabelsVisible(false);
                    BarChartGenerator.this.getStackedBarRenderer().setBaseItemLabelsVisible(false);
                    BarChartGenerator.this.getPercentageRenderer().setBaseItemLabelsVisible(false);
                }
            }
        };
        labels.addItemListener(il);
        list.add((Component)new JLabel("Labels"), (Component)labels);
        final JComboBox<String> barType = new JComboBox<String>();
        barType.setEditable(false);
        barType.setModel(new DefaultComboBoxModel<String>(new Vector<String>(Arrays.asList("Separate", "Stacked", "Percentage"))));
        barType.setSelectedIndex(0);
        barType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CategoryPlot plot = (CategoryPlot)BarChartGenerator.this.chart.getPlot();
                int type = barType.getSelectedIndex();
                if (type == 0) {
                    plot.setRenderer((CategoryItemRenderer)BarChartGenerator.this.getBarRenderer());
                } else if (type == 1) {
                    plot.setRenderer((CategoryItemRenderer)BarChartGenerator.this.getStackedBarRenderer());
                } else {
                    plot.setRenderer((CategoryItemRenderer)BarChartGenerator.this.getPercentageRenderer());
                }
            }
        });
        list.add((Component)new JLabel("Bars"), barType);
        JCheckBox horizontal = new JCheckBox();
        horizontal.setSelected(false);
        il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CategoryPlot plot = (CategoryPlot)BarChartGenerator.this.chart.getPlot();
                if (e.getStateChange() == 1) {
                    plot.setOrientation(PlotOrientation.HORIZONTAL);
                    BarChartGenerator.this.ishorizontal = true;
                } else {
                    plot.setOrientation(PlotOrientation.VERTICAL);
                    BarChartGenerator.this.ishorizontal = false;
                }
                BarChartGenerator.this.updateGridLines();
            }
        };
        horizontal.addItemListener(il);
        list.add((Component)new JLabel("Horizontal"), (Component)horizontal);
    }

    void updateGridLines() {
        if (this.hasgridlines) {
            if (this.ishorizontal) {
                this.chart.getCategoryPlot().setRangeGridlinesVisible(true);
                this.chart.getCategoryPlot().setDomainGridlinesVisible(false);
            } else {
                this.chart.getCategoryPlot().setRangeGridlinesVisible(true);
                this.chart.getCategoryPlot().setDomainGridlinesVisible(false);
            }
        } else {
            this.chart.getCategoryPlot().setRangeGridlinesVisible(false);
            this.chart.getCategoryPlot().setDomainGridlinesVisible(false);
        }
    }

    @Override
    public Dataset getSeriesDataset() {
        return ((CategoryPlot)this.chart.getPlot()).getDataset();
    }

    @Override
    public void setSeriesDataset(Dataset obj) {
        if (((CategoryDataset)obj).getRowCount() > 20) {
            ((CategoryPlot)this.chart.getPlot()).setDataset((CategoryDataset)this.emptyDataset);
            this.setInvalidChartTitle("[[ Dataset has too many items. ]]");
        } else {
            ((CategoryPlot)this.chart.getPlot()).setDataset((CategoryDataset)((DefaultCategoryDataset)obj));
            if (this.invalidChartTitle != null) {
                this.setInvalidChartTitle(null);
            }
        }
    }

    @Override
    protected void buildChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart((String)"Untitled Chart", (String)"Category", (String)"Value", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.chart.setAntiAlias(true);
        this.chartPanel = this.buildChartPanel(this.chart);
        this.setChartPanel(this.chartPanel);
        this.setSeriesDataset((Dataset)dataset);
    }

    @Override
    protected void update() {
        SeriesAttributes[] sa = this.getSeriesAttributes();
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < sa.length; ++i) {
            if (!sa[i].isPlotVisible()) continue;
            BarChartSeriesAttributes attributes = (BarChartSeriesAttributes)sa[i];
            double[] values = attributes.getValues();
            String[] labels = attributes.getLabels();
            PieChartGenerator.UniqueString seriesName = new PieChartGenerator.UniqueString(this, attributes.getSeriesName());
            for (int j = 0; j < values.length; ++j) {
                dataset.addValue(values[j], (Comparable)((Object)labels[j]), (Comparable)seriesName);
            }
        }
        this.setSeriesDataset((Dataset)dataset);
    }

    @Override
    SeriesAttributes addSeries(double[] amounts, String[] labels, String name, SeriesChangeListener stopper) {
        int i = this.getSeriesCount();
        BarChartSeriesAttributes csa = new BarChartSeriesAttributes(this, name, i, amounts, labels, stopper);
        this.seriesAttributes.add(csa);
        this.revalidate();
        this.update();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BarChartGenerator.this.update();
            }
        });
        return csa;
    }

    @Override
    public SeriesAttributes addSeries(Object[] objs, String name, SeriesChangeListener stopper) {
        HashMap map = this.convertIntoAmountsAndLabels(objs);
        String[] labels = this.revisedLabels(map);
        double[] amounts = this.amounts(map, labels);
        return this.addSeries(amounts, labels, name, stopper);
    }

    @Override
    public void updateSeries(int index, Object[] objs) {
        if (index < 0) {
            return;
        }
        if (index >= this.getNumSeriesAttributes()) {
            return;
        }
        HashMap map = this.convertIntoAmountsAndLabels(objs);
        String[] labels = this.revisedLabels(map);
        double[] amounts = this.amounts(map, labels);
        this.updateSeries(index, amounts, labels);
    }

    @Override
    void updateSeries(int index, double[] amounts, String[] labels) {
        if (index < 0) {
            return;
        }
        if (index >= this.getNumSeriesAttributes()) {
            return;
        }
        BarChartSeriesAttributes hsa = (BarChartSeriesAttributes)this.getSeriesAttribute(index);
        hsa.setValues(amounts);
        hsa.setLabels(labels);
    }
}

