/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.ui.RectangleInsets;
import sim.display.SimApplet;
import sim.util.gui.DisclosurePanel;
import sim.util.gui.LabelledList;
import sim.util.gui.MovieMaker;
import sim.util.gui.NumberTextField;
import sim.util.gui.PropertyField;
import sim.util.gui.Utilities;
import sim.util.media.PDFEncoder;
import sim.util.media.chart.SeriesAttributes;

public abstract class ChartGenerator
extends JPanel {
    protected Box globalAttributes = Box.createVerticalBox();
    protected Box seriesAttributes = Box.createVerticalBox();
    protected JFreeChart chart;
    protected ScrollableChartPanel chartPanel;
    private JScrollPane chartHolder = new JScrollPane();
    JFrame frame;
    PropertyField titleField;
    NumberTextField scaleField;
    NumberTextField proportionField;
    JCheckBox fixBox;
    JButton movieButton = new JButton("Create Movie");
    BufferedImage buffer;
    MovieMaker movieMaker = null;
    static final long INITIAL_KEY = -1L;
    public static final long FORCE_KEY = -2L;
    long oldKey = -1L;
    protected String invalidChartTitle = null;
    protected String validChartTitle = "";
    public double DEFAULT_CHART_HEIGHT = 480.0;
    public double DEFAULT_CHART_PROPORTION = 1.5;
    double scale = 1.0;
    double proportion = 1.5;
    Thread timer = null;
    static int DEFAULT_UNIT_FRACTION;
    static int DEFAULT_BLOCK_FRACTION;

    public void setChartPanel(ScrollableChartPanel chartPanel) {
        this.chartHolder.getViewport().setView((Component)((Object)chartPanel));
        this.chartPanel = chartPanel;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public abstract Dataset getSeriesDataset();

    public abstract void setSeriesDataset(Dataset var1);

    protected void update() {
    }

    protected abstract void buildChart();

    BufferedImage getBufferedImage() {
        if (this.buffer == null || this.buffer.getWidth(null) != this.chartPanel.getWidth() || this.buffer.getHeight(null) != this.chartPanel.getHeight()) {
            this.buffer = this.getGraphicsConfiguration().createCompatibleImage(this.chartPanel.getWidth(), this.chartPanel.getHeight());
        }
        Graphics2D g = (Graphics2D)this.buffer.getGraphics();
        g.setColor(this.chartPanel.getBackground());
        g.fillRect(0, 0, this.buffer.getWidth(null), this.buffer.getHeight(null));
        this.chartPanel.paintComponent(g);
        g.dispose();
        return this.buffer;
    }

    public void update(long key, boolean newData) {
        if (key == this.oldKey && key != -2L) {
            return;
        }
        this.oldKey = key;
        this.update();
        if (newData) {
            this.chart.getPlot().datasetChanged(new DatasetChangeEvent((Object)this.chart.getPlot(), null));
        }
        if (newData && this.movieMaker != null) {
            this.movieMaker.add(this.getBufferedImage());
        }
    }

    void rebuildAttributeIndices() {
        SeriesAttributes[] c = this.getSeriesAttributes();
        for (int i = 0; i < c.length; ++i) {
            SeriesAttributes csa = c[i];
            csa.setSeriesIndex(i);
            csa.rebuildGraphicsDefinitions();
        }
        this.revalidate();
    }

    protected SeriesAttributes getSeriesAttribute(int i) {
        return (SeriesAttributes)this.seriesAttributes.getComponent(i);
    }

    public int getNumSeriesAttributes() {
        return this.seriesAttributes.getComponents().length;
    }

    protected SeriesAttributes[] getSeriesAttributes() {
        Component[] c = this.seriesAttributes.getComponents();
        SeriesAttributes[] sa = new SeriesAttributes[c.length];
        System.arraycopy(c, 0, sa, 0, c.length);
        return sa;
    }

    protected void setSeriesAttributes(SeriesAttributes[] c) {
        this.seriesAttributes.removeAll();
        for (int i = 0; i < c.length; ++i) {
            this.seriesAttributes.add(c[i]);
        }
    }

    public void removeSeries(int index) {
        SeriesAttributes[] c = this.getSeriesAttributes();
        SeriesChangeListener tmpObj = c[index].getStoppable();
        if (tmpObj != null) {
            tmpObj.seriesChanged(new SeriesChangeEvent((Object)this));
        }
        Component comp = this.seriesAttributes.getComponent(index);
        ((SeriesAttributes)comp).setSeriesIndex(-1);
        this.seriesAttributes.remove(index);
        this.rebuildAttributeIndices();
        this.revalidate();
    }

    public void moveSeries(int index, boolean up) {
        if (index > 0 && up || index < this.getSeriesCount() - 1 && !up) {
            SeriesAttributes[] c = this.getSeriesAttributes();
            if (up) {
                SeriesAttributes s2;
                SeriesAttributes s1 = c[index];
                c[index] = s2 = c[index - 1];
                c[index - 1] = s1;
            } else {
                SeriesAttributes s2;
                SeriesAttributes s1 = c[index];
                c[index] = s2 = c[index + 1];
                c[index + 1] = s1;
            }
            this.setSeriesAttributes(c);
            this.rebuildAttributeIndices();
            this.revalidate();
        }
    }

    public void startMovie() {
        if (SimApplet.isApplet) {
            Object[] options = new Object[]{"Oops"};
            JOptionPane.showOptionDialog(this, "You cannot create movies from an applet.", "MASON Applet Restriction", 0, 0, null, options, options[0]);
            return;
        }
        if (this.movieMaker != null) {
            return;
        }
        this.movieMaker = new MovieMaker(this.getFrame());
        if (!this.movieMaker.start(this.getBufferedImage())) {
            this.movieMaker = null;
        } else {
            this.movieButton.setText("Stop Movie");
            this.update(-2L, true);
        }
    }

    public void stopMovie() {
        if (this.movieMaker == null) {
            return;
        }
        if (!this.movieMaker.stop()) {
            Object[] options = new Object[]{"Drat"};
            JOptionPane.showOptionDialog(this, "Your movie did not write to disk\ndue to a spurious JMF movie generation bug.", "JMF Movie Generation Bug", 0, 2, null, options, options[0]);
        }
        this.movieMaker = null;
        if (this.movieButton != null) {
            this.movieButton.setText("Create Movie");
        }
    }

    public abstract int getSeriesCount();

    public void removeAllSeries() {
        for (int x = this.getSeriesCount() - 1; x >= 0; --x) {
            this.removeSeries(x);
        }
    }

    public void quit() {
        if (this.movieMaker != null) {
            this.movieMaker.stop();
        }
        this.removeAllSeries();
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void addGlobalAttribute(Component component) {
        this.globalAttributes.add(component);
    }

    public Component getGlobalAttribute(int index) {
        return this.globalAttributes.getComponent(index + 2);
    }

    public int getGlobalAttributeCount() {
        return this.getNumGlobalAttributes();
    }

    public int getNumGlobalAttributes() {
        return this.globalAttributes.getComponentCount() - 2;
    }

    public Component removeGlobalAttribute(int index) {
        Component component = this.getGlobalAttribute(index);
        this.globalAttributes.remove(index);
        return component;
    }

    public void setInvalidChartTitle(String title) {
        this.invalidChartTitle = title;
        this.setTitle(this.validChartTitle);
    }

    public void setTitle(String title) {
        this.validChartTitle = title;
        if (this.invalidChartTitle != null) {
            title = this.invalidChartTitle;
        }
        this.chart.setTitle(title);
        this.chart.titleChanged(new TitleChangeEvent((Title)new TextTitle(title)));
        if (this.frame != null) {
            this.frame.setTitle(title);
        }
        this.titleField.setValue(title);
    }

    public String getTitle() {
        return this.validChartTitle;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    protected void buildGlobalAttributes(LabelledList list) {
    }

    public ChartGenerator() {
        this.buildChart();
        this.chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        this.chart.setAntiAlias(true);
        JSplitPane split = new JSplitPane(1, true);
        split.setBorder(new EmptyBorder(0, 0, 0, 0));
        JScrollPane scroll = new JScrollPane();
        JPanel b = new JPanel();
        b.setLayout(new BorderLayout());
        b.add((Component)this.seriesAttributes, "North");
        b.add((Component)new JPanel(), "Center");
        scroll.getViewport().setView(b);
        scroll.setBackground(this.getBackground());
        scroll.getViewport().setBackground(this.getBackground());
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        LabelledList list = new LabelledList("Chart Properties");
        DisclosurePanel pan1 = new DisclosurePanel("Chart Properties", (Component)list);
        this.globalAttributes.add(pan1);
        JLabel j = new JLabel("Right-Click or Control-Click");
        j.setFont(j.getFont().deriveFont(10.0f).deriveFont(2));
        list.add(j);
        j = new JLabel("on Chart for More Options");
        j.setFont(j.getFont().deriveFont(10.0f).deriveFont(2));
        list.add(j);
        this.titleField = new PropertyField(){

            @Override
            public String newValue(String newValue) {
                ChartGenerator.this.setTitle(newValue);
                ChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.titleField.setValue(this.chart.getTitle().getText());
        list.add((Component)new JLabel("Title"), (Component)this.titleField);
        this.buildGlobalAttributes(list);
        JCheckBox legendCheck = new JCheckBox();
        legendCheck.setSelected(false);
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LegendTitle title = new LegendTitle((LegendItemSource)ChartGenerator.this.chart.getPlot());
                    title.setLegendItemGraphicPadding(new RectangleInsets(0.0, 8.0, 0.0, 4.0));
                    ChartGenerator.this.chart.addLegend(title);
                } else {
                    ChartGenerator.this.chart.removeLegend();
                }
            }
        };
        legendCheck.addItemListener(il);
        list.add((Component)new JLabel("Legend"), (Component)legendCheck);
        JPanel pdfButtonPanel = new JPanel();
        pdfButtonPanel.setBorder(new TitledBorder("Chart Output"));
        DisclosurePanel pan2 = new DisclosurePanel("Chart Output", (Component)pdfButtonPanel);
        pdfButtonPanel.setLayout(new BorderLayout());
        Box pdfbox = new Box(1);
        pdfButtonPanel.add((Component)pdfbox, "West");
        JButton pdfButton = new JButton("Save as PDF");
        pdfbox.add(pdfButton);
        pdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDialog fd = new FileDialog((Frame)ChartGenerator.this.frame, "Choose PDF file...", 1);
                fd.setFile(ChartGenerator.this.chart.getTitle().getText() + ".pdf");
                fd.setVisible(true);
                String fileName = fd.getFile();
                if (fileName != null) {
                    Dimension dim = ChartGenerator.this.chartPanel.getPreferredSize();
                    PDFEncoder.generatePDF(ChartGenerator.this.chart, dim.width, dim.height, new File(fd.getDirectory(), Utilities.ensureFileEndsWith(fd.getFile(), ".pdf")));
                }
            }
        });
        this.movieButton = new JButton("Create a Movie");
        pdfbox.add(this.movieButton);
        pdfbox.add(Box.createGlue());
        this.movieButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChartGenerator.this.movieMaker == null) {
                    ChartGenerator.this.startMovie();
                } else {
                    ChartGenerator.this.stopMovie();
                }
            }
        });
        this.globalAttributes.add(pan2);
        Box outerAttributes = Box.createVerticalBox();
        outerAttributes.add(this.globalAttributes);
        outerAttributes.add(Box.createGlue());
        p.add((Component)outerAttributes, "North");
        p.add((Component)scroll, "Center");
        p.setMinimumSize(new Dimension(0, 0));
        p.setPreferredSize(new Dimension(200, 0));
        split.setLeftComponent(p);
        Box header = Box.createHorizontalBox();
        double MAXIMUM_SCALE = 8.0;
        this.fixBox = new JCheckBox("Fill");
        this.fixBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartGenerator.this.setFixed(ChartGenerator.this.fixBox.isSelected());
            }
        });
        header.add(this.fixBox);
        this.fixBox.setSelected(true);
        this.scaleField = new NumberTextField("  Scale: ", 1.0, true){

            @Override
            public double newValue(double newValue) {
                if (newValue <= 0.0) {
                    newValue = this.currentValue;
                }
                if (newValue > 8.0) {
                    newValue = this.currentValue;
                }
                ChartGenerator.this.scale = newValue;
                ChartGenerator.this.resizeChart();
                return newValue;
            }
        };
        this.scaleField.setToolTipText("Zoom in and out");
        this.scaleField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.scaleField.setEnabled(false);
        this.scaleField.setText("");
        header.add(this.scaleField);
        this.proportionField = new NumberTextField("  Proportion: ", 1.5, true){

            @Override
            public double newValue(double newValue) {
                if (newValue <= 0.0) {
                    newValue = this.currentValue;
                }
                ChartGenerator.this.proportion = newValue;
                ChartGenerator.this.resizeChart();
                return newValue;
            }
        };
        this.proportionField.setToolTipText("Change the chart proportions (ratio of width to height)");
        this.proportionField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        header.add(this.proportionField);
        this.chartHolder.setMinimumSize(new Dimension(0, 0));
        this.chartHolder.setHorizontalScrollBarPolicy(31);
        this.chartHolder.setVerticalScrollBarPolicy(22);
        this.chartHolder.getViewport().setBackground(Color.gray);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add((Component)this.chartHolder, "Center");
        p2.add((Component)header, "North");
        split.setRightComponent(p2);
        this.setLayout(new BorderLayout());
        this.add((Component)split, "Center");
        this.chart.setBackgroundPaint((Paint)Color.WHITE);
        this.chartPanel.setMinimumDrawHeight((int)this.DEFAULT_CHART_HEIGHT);
        this.chartPanel.setMaximumDrawHeight((int)this.DEFAULT_CHART_HEIGHT);
        this.chartPanel.setMinimumDrawWidth((int)(this.DEFAULT_CHART_HEIGHT * this.proportion));
        this.chartPanel.setMaximumDrawWidth((int)(this.DEFAULT_CHART_HEIGHT * this.proportion));
        this.chartPanel.setPreferredSize(new Dimension((int)(this.DEFAULT_CHART_HEIGHT * this.DEFAULT_CHART_PROPORTION), (int)this.DEFAULT_CHART_HEIGHT));
    }

    public boolean isFixed() {
        return this.fixBox.isSelected();
    }

    public void setFixed(boolean value) {
        this.fixBox.setSelected(value);
        this.chartHolder.setHorizontalScrollBarPolicy(value ? 31 : 32);
        this.scaleField.setEnabled(!value);
        if (value) {
            this.scaleField.setText("");
        } else {
            double val = this.scaleField.getValue();
            if (val == (double)((int)val)) {
                this.scaleField.setText("" + (int)val);
            } else {
                this.scaleField.setText("" + val);
            }
        }
        this.resizeChart();
    }

    public double getScale() {
        return this.scale;
    }

    public double getProportion() {
        return this.proportion;
    }

    public void setScale(double val) {
        this.scale = val;
        this.scaleField.setValue(val);
        this.resizeChart();
    }

    public void setProportion(double val) {
        this.proportion = val;
        this.proportionField.setValue(val);
        this.resizeChart();
    }

    void resizeChart() {
        double w = this.DEFAULT_CHART_HEIGHT * this.scale * this.proportion;
        double h = this.DEFAULT_CHART_HEIGHT * this.scale;
        Dimension d = new Dimension((int)w, (int)h);
        this.chartPanel.setSize(new Dimension(d));
        this.chartPanel.setPreferredSize(this.chartPanel.getSize());
        this.chartPanel.setMinimumDrawHeight((int)this.DEFAULT_CHART_HEIGHT);
        this.chartPanel.setMaximumDrawHeight((int)this.DEFAULT_CHART_HEIGHT);
        this.chartPanel.setMinimumDrawWidth((int)(this.DEFAULT_CHART_HEIGHT * this.proportion));
        this.chartPanel.setMaximumDrawWidth((int)(this.DEFAULT_CHART_HEIGHT * this.proportion));
        this.chartPanel.repaint();
    }

    public JFrame createFrame() {
        return this.createFrame(false);
    }

    public JFrame createFrame(boolean inspector) {
        this.frame = new JFrame(){

            @Override
            public void dispose() {
                ChartGenerator.this.quit();
                super.dispose();
            }
        };
        if (inspector) {
            this.frame.getRootPane().putClientProperty("Window.style", "small");
        }
        this.frame.setDefaultCloseOperation(1);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this, "Center");
        this.frame.setResizable(true);
        this.frame.pack();
        this.frame.setTitle(this.chart.getTitle().getText());
        return this.frame;
    }

    public JFrame createFrame(Object simulation) {
        return this.createFrame();
    }

    public void addLegend() {
        if (this.chart.getLegend() != null) {
            return;
        }
        LegendTitle title = new LegendTitle((LegendItemSource)this.chart.getPlot());
        title.setLegendItemGraphicPadding(new RectangleInsets(0.0, 8.0, 0.0, 4.0));
        this.chart.addLegend(title);
    }

    public void updateChartWithin(final long key, long milliseconds) {
        if (this.timer == null) {
            this.timer = Utilities.doLater(milliseconds, new Runnable(){

                @Override
                public void run() {
                    ChartGenerator.this.update(key, true);
                    ChartGenerator.this.timer = null;
                }
            });
        }
    }

    public void updateChartLater(final long key) {
        this.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChartGenerator.this.update(key, true);
            }
        });
    }

    public ScrollableChartPanel buildChartPanel(JFreeChart chart) {
        return new ScrollableChartPanel(chart, true);
    }

    static {
        try {
            String version = System.getProperty("java.version");
            if (!version.startsWith("1.3")) {
                UIManager.put("ColorChooserUI", Class.forName("ch.randelshofer.quaqua.Quaqua14ColorChooserUI").getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_UNIT_FRACTION = 20;
        DEFAULT_BLOCK_FRACTION = 2;
    }

    class ScrollableChartPanel
    extends ChartPanel
    implements Scrollable {
        public ScrollableChartPanel(JFreeChart chart, boolean useBuffer) {
            super(chart, useBuffer);
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            int viewportWidth = ChartGenerator.this.chartHolder.getViewport().getWidth();
            if (viewportWidth == 0) {
                return size;
            }
            if (ChartGenerator.this.isFixed()) {
                size.height = (int)((double)size.height / (double)size.width * (double)viewportWidth);
            }
            return size;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (int)(orientation == 0 ? visibleRect.getWidth() / (double)DEFAULT_UNIT_FRACTION : visibleRect.getHeight() / (double)DEFAULT_UNIT_FRACTION);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (int)(orientation == 0 ? visibleRect.getWidth() / (double)DEFAULT_BLOCK_FRACTION : visibleRect.getHeight() / (double)DEFAULT_BLOCK_FRACTION);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return ChartGenerator.this.isFixed();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setSize(Dimension d) {
            super.setSize(d);
        }
    }
}

