/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import sim.util.IntBag;
import sim.util.media.chart.DataCuller;

public class MinGapDataCuller
implements DataCuller {
    int maxPointCount;
    int pointCountAfterCulling;
    IntBag reusableIntBag;

    public MinGapDataCuller(int maxPointCount) {
        this(maxPointCount, maxPointCount / 2 + 1);
    }

    public MinGapDataCuller(int maxPointCount, int pointCountAfterCulling) {
        this.setMaxAndMinCounts(maxPointCount, pointCountAfterCulling);
        this.reusableIntBag = new IntBag(maxPointCount - pointCountAfterCulling + 1);
    }

    @Override
    public boolean tooManyPoints(int currentPointCount) {
        return currentPointCount > this.maxPointCount;
    }

    void setMaxAndMinCounts(int maxPointCount, int pointCountAfterCulling) {
        this.maxPointCount = maxPointCount;
        this.pointCountAfterCulling = pointCountAfterCulling;
    }

    static void sort(IntBag indices, int maxPoints) {
        int i;
        boolean[] map = new boolean[maxPoints];
        for (i = 0; i < indices.numObjs; ++i) {
            map[indices.objs[i]] = true;
        }
        indices.clear();
        for (i = 0; i < maxPoints; ++i) {
            if (!map[i]) continue;
            indices.add(i);
        }
    }

    @Override
    public IntBag cull(double[] xValues, boolean sortedOutput) {
        return this.cull(xValues, this.reusableIntBag, sortedOutput);
    }

    IntBag cull(double[] xValues, IntBag droppedIndices, boolean sortOutput) {
        return this.cull(xValues, this.pointCountAfterCulling, droppedIndices, sortOutput);
    }

    IntBag cull(double[] xValues, int size, IntBag droppedIndices, boolean sortOutput) {
        IntBag bag = MinGapDataCuller.cullToSize(xValues, size, droppedIndices);
        if (sortOutput) {
            MinGapDataCuller.sort(bag, xValues.length);
        }
        return bag;
    }

    public static IntBag cullToSize(double[] xValues, int size, IntBag droppedIndices) {
        droppedIndices.clear();
        int pointsToDrop = xValues.length - size;
        if (pointsToDrop <= 0) {
            return droppedIndices;
        }
        if (xValues.length <= 2) {
            for (int i = 0; i < pointsToDrop; ++i) {
                droppedIndices.add(i);
            }
            return droppedIndices;
        }
        if (pointsToDrop == 1) {
            double bestGapSumSoFar = Double.MAX_VALUE;
            int index = -1;
            double lastX = xValues[1];
            double lastGap = xValues[1] - xValues[0];
            for (int i = 2; i < xValues.length; ++i) {
                double xi = xValues[i];
                double gap = xi - lastX;
                lastX = xi;
                double gapSum = gap + lastGap;
                lastGap = gap;
                if (!(gapSum < bestGapSumSoFar)) continue;
                index = i - 1;
                bestGapSumSoFar = gapSum;
            }
            droppedIndices.add(index);
            return droppedIndices;
        }
        Heap h = new Heap(xValues);
        for (int i = 0; i < pointsToDrop; ++i) {
            droppedIndices.add(h.extractMin().xValueIndex);
        }
        return droppedIndices;
    }

    static class Heap {
        int heapsize;
        Record[] heap;

        Heap(double[] xValues) {
            int i;
            this.heapsize = xValues.length - 2;
            this.heap = new Record[this.heapsize];
            double currentX = xValues[1];
            double lastGap = currentX - xValues[0];
            if (lastGap <= 0.0) {
                throw new RuntimeException("I expect xValues in strictly increasing order.");
            }
            Record lastRecord = null;
            for (i = 1; i < xValues.length - 1; ++i) {
                double nextX = xValues[i + 1];
                double nextGap = nextX - currentX;
                if (nextGap <= 0.0) {
                    throw new RuntimeException("I expect xValues in strictly increasing order.");
                }
                Record ri = new Record(i, lastGap, nextGap, i);
                ri.leftRecord = lastRecord;
                if (lastRecord != null) {
                    lastRecord.rightRecord = ri;
                }
                lastRecord = ri;
                currentX = nextX;
                lastGap = nextGap;
                this.heap[i - 1] = ri;
            }
            for (i = this.heapsize / 2; i >= 1; --i) {
                this.heapify(i);
            }
        }

        Record extractMin() {
            if (this.heapsize == 0) {
                return null;
            }
            Record result = this.heap[0];
            this.heap[0] = this.heap[this.heapsize - 1];
            this.heap[0].heapPosition = 1;
            this.heap[this.heapsize - 1] = null;
            --this.heapsize;
            if (this.heapsize > 1) {
                this.heapify(1);
                Record leftRecord = result.leftRecord;
                Record rightRecord = result.rightRecord;
                if (rightRecord != null && rightRecord.leftGap != result.rightGap) {
                    throw new RuntimeException("BUG");
                }
                if (leftRecord != null) {
                    if (leftRecord.rightGap != result.leftGap) {
                        throw new RuntimeException("BUG");
                    }
                    leftRecord.setRightGap(result.key);
                    leftRecord.rightRecord = result.rightRecord;
                    this.heapify(leftRecord.heapPosition);
                }
                if (rightRecord != null) {
                    rightRecord.setLeftGap(result.key);
                    rightRecord.leftRecord = result.leftRecord;
                    this.heapify(rightRecord.heapPosition);
                }
            }
            return result;
        }

        void heapify(int i) {
            while (true) {
                int l = 2 * i;
                int r = 2 * i + 1;
                int smallest = l <= this.heapsize && this.heap[l - 1].compareTo(this.heap[i - 1]) < 0 ? l : i;
                if (r <= this.heapsize && this.heap[r - 1].compareTo(this.heap[smallest - 1]) < 0) {
                    smallest = r;
                }
                if (smallest == i) break;
                Record tmp = this.heap[i - 1];
                this.heap[i - 1] = this.heap[smallest - 1];
                this.heap[smallest - 1] = tmp;
                this.heap[i - 1].heapPosition = i;
                this.heap[smallest - 1].heapPosition = smallest;
                i = smallest;
            }
        }
    }

    static class Record
    implements Comparable {
        int xValueIndex;
        double leftGap;
        double rightGap;
        double key;
        Record leftRecord;
        Record rightRecord;
        int heapPosition;

        Record(int xValueIndex, double leftGap, double rightGap, int heapPosition) {
            this.xValueIndex = xValueIndex;
            this.leftGap = leftGap;
            this.rightGap = rightGap;
            this.key = leftGap + rightGap;
            this.heapPosition = heapPosition;
        }

        public int compareTo(Object o) {
            Record r = (Record)o;
            double keydiff = this.key - r.key;
            if (keydiff == 0.0) {
                return this.xValueIndex - r.xValueIndex;
            }
            return keydiff <= 0.0 ? -1 : 1;
        }

        void setLeftGap(double lg) {
            this.leftGap = lg;
            this.key = this.leftGap + this.rightGap;
        }

        void setRightGap(double rg) {
            this.rightGap = rg;
            this.key = this.leftGap + this.rightGap;
        }
    }
}

