/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import sim.util.media.chart.ScatterPlotSeriesAttributes;
import sim.util.media.chart.SeriesAttributes;
import sim.util.media.chart.XYChartGenerator;

public class ScatterPlotGenerator
extends XYChartGenerator {
    @Override
    public void removeSeries(int index) {
        super.removeSeries(index);
        this.update();
    }

    @Override
    public void moveSeries(int index, boolean up) {
        super.moveSeries(index, up);
        this.update();
    }

    @Override
    protected void buildChart() {
        DefaultXYDataset dataset = new DefaultXYDataset();
        this.chart = ChartFactory.createScatterPlot((String)"Untitled Chart", (String)"Untitled X Axis", (String)"Untitled Y Axis", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.chart.setAntiAlias(true);
        this.chartPanel = this.buildChartPanel(this.chart);
        this.setChartPanel(this.chartPanel);
        this.chart.getXYPlot().setRenderer((XYItemRenderer)new XYLineAndShapeRenderer(false, true));
        this.setSeriesDataset((Dataset)dataset);
    }

    @Override
    protected void update() {
        SeriesAttributes[] sa = this.getSeriesAttributes();
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        DefaultXYDataset dataset = new DefaultXYDataset();
        for (int i = 0; i < sa.length; ++i) {
            ScatterPlotSeriesAttributes attributes = (ScatterPlotSeriesAttributes)sa[i];
            dataset.addSeries((Comparable)((Object)attributes.getSeriesName()), attributes.getValues());
        }
        this.setSeriesDataset((Dataset)dataset);
    }

    public SeriesAttributes addSeries(double[][] values, String name, SeriesChangeListener stopper) {
        DefaultXYDataset dataset = (DefaultXYDataset)this.getSeriesDataset();
        int i = dataset.getSeriesCount();
        dataset.addSeries((Comparable)((Object)name), values);
        ScatterPlotSeriesAttributes csa = new ScatterPlotSeriesAttributes(this, name, i, values, stopper);
        this.seriesAttributes.add(csa);
        this.revalidate();
        this.update();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScatterPlotGenerator.this.update();
            }
        });
        return csa;
    }

    public void updateSeries(int index, double[][] vals) {
        if (index < 0) {
            return;
        }
        if (index >= this.getNumSeriesAttributes()) {
            return;
        }
        ScatterPlotSeriesAttributes series = (ScatterPlotSeriesAttributes)this.getSeriesAttribute(index);
        series.setValues(vals);
    }
}

