/*
 * Decompiled with CFR 0.152.
 */
package sim.util.media.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYDataset;
import sim.util.gui.LabelledList;
import sim.util.gui.PropertyField;
import sim.util.media.chart.ChartGenerator;

public abstract class XYChartGenerator
extends ChartGenerator {
    PropertyField xLabel;
    PropertyField yLabel;
    JCheckBox yLog;
    JCheckBox xLog;

    public void setXAxisLogScaled(boolean isLogScaled) {
        this.xLog.setSelected(isLogScaled);
    }

    public boolean isXAxisLogScaled() {
        return this.xLog.isSelected();
    }

    public void setYAxisLogScaled(boolean isLogScaled) {
        this.yLog.setSelected(isLogScaled);
    }

    public boolean isYAxisLogScaled() {
        return this.yLog.isSelected();
    }

    @Override
    public Dataset getSeriesDataset() {
        return ((XYPlot)this.chart.getPlot()).getDataset();
    }

    @Override
    public void setSeriesDataset(Dataset obj) {
        ((XYPlot)this.chart.getPlot()).setDataset((XYDataset)obj);
    }

    @Override
    public int getSeriesCount() {
        return ((XYDataset)this.getSeriesDataset()).getSeriesCount();
    }

    public void setRangeAxisLabel(String val) {
        this.setYAxisLabel(val);
    }

    public void setYAxisLabel(String val) {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.getRangeAxis().setLabel(val);
        xyplot.axisChanged(new AxisChangeEvent((Axis)xyplot.getRangeAxis()));
        this.yLabel.setValue(val);
    }

    public String getRangeAxisLabel() {
        return this.getYAxisLabel();
    }

    public String getYAxisLabel() {
        return ((XYPlot)this.chart.getPlot()).getRangeAxis().getLabel();
    }

    public void setDomainAxisLabel(String val) {
        this.setXAxisLabel(val);
    }

    public void setXAxisLabel(String val) {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.getDomainAxis().setLabel(val);
        xyplot.axisChanged(new AxisChangeEvent((Axis)xyplot.getDomainAxis()));
        this.xLabel.setValue(val);
    }

    public String getDomainAxisLabel() {
        return this.getXAxisLabel();
    }

    public String getXAxisLabel() {
        return ((XYPlot)this.chart.getPlot()).getDomainAxis().getLabel();
    }

    @Override
    public JFreeChart getChart() {
        return this.chart;
    }

    @Override
    protected void buildGlobalAttributes(LabelledList list) {
        ((XYPlot)this.chart.getPlot()).setDomainGridlinesVisible(false);
        ((XYPlot)this.chart.getPlot()).setRangeGridlinesVisible(false);
        ((XYPlot)this.chart.getPlot()).setDomainGridlinePaint((Paint)new Color(200, 200, 200));
        ((XYPlot)this.chart.getPlot()).setRangeGridlinePaint((Paint)new Color(200, 200, 200));
        this.xLabel = new PropertyField(){

            @Override
            public String newValue(String newValue) {
                XYChartGenerator.this.setXAxisLabel(newValue);
                XYChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.xLabel.setValue(this.getXAxisLabel());
        list.add((Component)new JLabel("X Label"), (Component)this.xLabel);
        this.yLabel = new PropertyField(){

            @Override
            public String newValue(String newValue) {
                XYChartGenerator.this.setYAxisLabel(newValue);
                XYChartGenerator.this.getChartPanel().repaint();
                return newValue;
            }
        };
        this.yLabel.setValue(this.getYAxisLabel());
        list.add((Component)new JLabel("Y Label"), (Component)this.yLabel);
        this.xLog = new JCheckBox();
        this.xLog.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (XYChartGenerator.this.xLog.isSelected()) {
                    LogarithmicAxis logAxis = new LogarithmicAxis(XYChartGenerator.this.xLabel.getValue());
                    logAxis.setStrictValuesFlag(false);
                    XYChartGenerator.this.chart.getXYPlot().setDomainAxis((ValueAxis)logAxis);
                } else {
                    XYChartGenerator.this.chart.getXYPlot().setDomainAxis((ValueAxis)new NumberAxis(XYChartGenerator.this.xLabel.getValue()));
                }
            }
        });
        this.yLog = new JCheckBox();
        this.yLog.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (XYChartGenerator.this.yLog.isSelected()) {
                    LogarithmicAxis logAxis = new LogarithmicAxis(XYChartGenerator.this.yLabel.getValue());
                    logAxis.setStrictValuesFlag(false);
                    XYChartGenerator.this.chart.getXYPlot().setRangeAxis((ValueAxis)logAxis);
                } else {
                    XYChartGenerator.this.chart.getXYPlot().setRangeAxis((ValueAxis)new NumberAxis(XYChartGenerator.this.yLabel.getValue()));
                }
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("X"));
        box.add(this.xLog);
        box.add(new JLabel(" Y"));
        box.add(this.yLog);
        box.add(Box.createGlue());
        list.add((Component)new JLabel("Log Axis"), (Component)box);
        JCheckBox xgridlines = new JCheckBox();
        xgridlines.setSelected(false);
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    XYChartGenerator.this.chart.getXYPlot().setDomainGridlinesVisible(true);
                } else {
                    XYChartGenerator.this.chart.getXYPlot().setDomainGridlinesVisible(false);
                }
            }
        };
        xgridlines.addItemListener(il);
        JCheckBox ygridlines = new JCheckBox();
        ygridlines.setSelected(false);
        il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    XYChartGenerator.this.chart.getXYPlot().setRangeGridlinesVisible(true);
                } else {
                    XYChartGenerator.this.chart.getXYPlot().setRangeGridlinesVisible(false);
                }
            }
        };
        ygridlines.addItemListener(il);
        box = Box.createHorizontalBox();
        box.add(new JLabel("X"));
        box.add(xgridlines);
        box.add(new JLabel(" Y"));
        box.add(ygridlines);
        box.add(Box.createGlue());
        list.add((Component)new JLabel("Grid Lines"), (Component)box);
    }

    public void setRangeAxisRange(double lower, double upper) {
        this.setYAxisRange(lower, upper);
    }

    public void setYAxisRange(double lower, double upper) {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.getRangeAxis().setRange(lower, upper);
    }

    public void setDomainAxisRange(double lower, double upper) {
        this.setXAxisRange(lower, upper);
    }

    public void setXAxisRange(double lower, double upper) {
        XYPlot xyplot = (XYPlot)this.chart.getPlot();
        xyplot.getDomainAxis().setRange(lower, upper);
    }
}

