package sim.app.crowd3d;

import sim.portrayal3d.*;
import javax.media.j3d.*;

/**
 * portrayal3D for the GullCG compressed geometry
 * 
 * FixPortrayal3D(new GullCG()) won't do, since
 * GullCG is NodeComponnent, and should be
 * wrapped into a Node.
 * The bigger problem is that it must be
 * cloned or shared, so you can actually see more of them.
 * 
 * */
public class GullPortrayal3D extends SimplePortrayal3D
    {
    static final SharedGroup gullModel;
    static 
	{
	Shape3D gullShape = new Shape3D(new GullCG());
		

    	gullModel = new SharedGroup();
    	gullModel.addChild(gullShape);
    	gullModel.compile();
	}
    
    public GullPortrayal3D(){}


    public TransformGroup getModel(Object obj, TransformGroup tg)
	{
	if(tg ==null)
	    {
	    TransformGroup j3dModel = new TransformGroup();
	    j3dModel.addChild(new Link(gullModel));
	    return j3dModel;
	    }
	else return tg;
	}
    }
