
package sim.app.cto;
import sim.portrayal.continuous.*;
import sim.engine.*;
import sim.display.*;
import javax.swing.*;
import java.awt.Color;

public class CooperativeObservationWithUI extends GUIState
    {
    public Display2D display;
    public JFrame displayFrame;

    ContinuousPortrayal2D coPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args)
        {
        CooperativeObservationWithUI co = new CooperativeObservationWithUI();
        Console c = new Console(co);
        c.setVisible(true);
        }

    public CooperativeObservationWithUI() { super(new CooperativeObservation( System.currentTimeMillis())); }
    public CooperativeObservationWithUI(SimState state) { super(state); }

    public String getName() { return "Cooperative Target Observation!"; }
    
    public String getInfo(boolean inHTML)  // we'll just assume it's HTML
	{
        CooperativeObservation co = (CooperativeObservation) state;
        return
	    "<H2>Cooperative Target Observation</H2>by Liviu Panait.<p>Parameters:" +
	    "<p><table><tr><td bgcolor=\"#3366CC\">Name</td><td bgcolor=\"#3366CC\">Value</td></tr>"+
	    "<tr><td>Number of Agents</td><td>" + CooperativeObservation.NUM_AGENTS  + "</td></tr>" +
	    "<tr><td>Number of Targets</td><td>" + CooperativeObservation.NUM_TARGETS  + "</td></tr>" +
	    "<tr><td>Diameter of Robot</td><td>" + CooperativeObservation.DIAMETER  + "</td></tr>" +
	    "</table>";
	}
    
    public void start()
	{
        super.start();
        setupPortrayals();
	}

    public void load(SimState state)
        {
        super.load(state);
        setupPortrayals();
        }
        
    public void setupPortrayals()
        {
        // tell the portrayals what to portray and how to portray them
        coPortrayal.setField(((CooperativeObservation)state).environment);
        // reschedule the displayer
        display.reset();
        display.setBackdrop(Color.white);
                
        // redraw the display
        display.repaint();
        }

    public void init(Controller c)
        {
        super.init(c);

        // make the displayer
        display = new Display2D(600,600,this,1);

        displayFrame = display.createFrame();
        displayFrame.setTitle("Cooperative Target Observation Display");
        c.registerFrame(displayFrame);   // register the frame so it appears in the "Display" list
        displayFrame.setVisible(true);
        display.attach( coPortrayal, "Agents" );
        }
        
    public void quit()
        {
        super.quit();
        
        if (displayFrame!=null) displayFrame.dispose();
        displayFrame = null;
        display = null;
        }

    }
