package sim.app.mousetraps3d;

import sim.engine.*;
import sim.display.*;
import sim.display3d.*;
import sim.app.mousetraps.*;
import sim.util.gui.*;
import sim.portrayal3d.grid.*;
import sim.portrayal3d.simple.*;
import sim.portrayal3d.continuous.*;
import sim.portrayal3d.grid.quad.*;
import java.awt.*;
import javax.swing.*;

public class MouseTraps3DWithUI extends GUIState
    {
    public JFrame mDisplayFrame; 
	
    ValueGrid2DPortrayal3D trapsPortrayal = new ValueGrid2DPortrayal3D();
    ContinuousPortrayal3D ballPortrayal = new ContinuousPortrayal3D();
    WireFrameBoxPortrayal3D wireFrameP;

    public static void main(String[] args)
	{
	MouseTraps3DWithUI simGUI = new MouseTraps3DWithUI();
	Console c = new Console(simGUI);
	c.setVisible(true);        
	}
	
    public MouseTraps3DWithUI() 
	{ 
	super(new MouseTraps(System.currentTimeMillis(), 40.0,15,10,120.0,80.0,false)); 
        // ... or...
//	super(new MouseTraps(System.currentTimeMillis(), 3.9,100,100,10.0,10.0,false)); 
	}
    
    double scale;
	
    public String getInfo()
	{ 
	MouseTraps sim = (MouseTraps) state;
	return 	    "<H2>Mouse Traps</H2>by Gabriel Balan." +
	    "<p><table><tr><td bgcolor=\"#3366CC\">Name</td><td bgcolor=\"#3366CC\">Value</td></tr>"+
	    "<tr><td>Number of balls on a trap </td><td>" + MouseTraps.BALLS_PER_TRAP  + "</td></tr>" +
	    "<tr><td>Initial velocity of ball leaving a trap</td><td>" + sim.initialVelocity  + "</td></tr>" +
	    "<tr><td>Number of traps</td><td>" + sim.trapGridWidth+" x "+ sim.trapGridHeight + "</td></tr>" +
	    "</table>"; 

	}
    public void start()
	{
	super.start();
	setup3DPortrayals();
	}
	 
    public void load(SimState state)
	{
	super.load(state);
	// we now have new grids.  Set up the portrayals to reflect that
	setup3DPortrayals();
	}
	    
    public void setup3DPortrayals()
	{    	
	trapsPortrayal.setField(((MouseTraps)state).trapStateGrid);
	ballPortrayal.setField(((MouseTraps)state).ballSpace);
	ballPortrayal.setPortrayalForAll(new SpherePortrayal3D(Color.green));

        // rebuild the scene graph
	mDisplay.createSceneGraph();

	// reschedule the displayer
	mDisplay.reset();        
	}
	
    public Display3D mDisplay;
	
    public void init(Controller c)
	{
	super.init(c);
        
        /// Build the portrayals
        
	MouseTraps sim = (MouseTraps) state;
        trapsPortrayal.setField(sim.trapStateGrid);
	SimpleColorMap map = new SimpleColorMap();
	map.setLevels(0.0,1.0,Color.blue,Color.gray);
	trapsPortrayal.setPortrayalForAll(new TilePortrayal(map));

        // the trapsPortrayal is a grid portrayal.  These suckers by default have the
        // CENTER of their <0,0> grid element at the origin:
        //
        // C-------+-------+---
        // |       |       |
        // |   x   |       |  ...
        // |       |       | 
        // +-------+-------+
        // |       |
        // |  ...
        //
        // The center is marked with an x.  We want the origin to be at the CORNER
        // of the <0,0> grid element (marked with a C) so that the corner lines up
        // with the <0,0> position in the continuous wireframe space.  To do this
        // we need to translate the trapsPortrayal by 0.5 units in the x and y 
        // directions each (a grid element is 1 unit).
        
        trapsPortrayal.translate(0.5,0.5,0);
        
        // Now keep in mind that the grid elements are 1 unit each.  This is much
        // smaller scale than the continuous space.  We need to scale up the
        // trapsPortrayal so that one grid element is equal to the right number
        // of continuous space units.  The easiest way to do this is just to scale
        // by the ratio of their relative widths (or relative heights).
        
        trapsPortrayal.scale(sim.spaceWidth / sim.trapGridWidth);
        
        // Now we build the ball portrayal (the continuous3D space)
        ballPortrayal.setField(sim.ballSpace);

        // finally we'll build a wireframe around it all
        
        wireFrameP = new WireFrameBoxPortrayal3D(0,0,0,sim.spaceWidth, sim.spaceHeight, sim.spaceLength);

	// Make the Display3D.  We'll have it display stuff later.
	mDisplay = new Display3D(600,600,this,1);
		
	// attach the portrayals to the displayer, from bottom to top
	mDisplay.attach(trapsPortrayal,"Traps");
	mDisplay.attach(ballPortrayal, "Balls");
	mDisplay.attach(wireFrameP, "Fish tank");
	
	// translate the whole kit and caboodle into the center
	mDisplay.translate(-sim.spaceWidth/2, -sim.spaceHeight/2, -sim.spaceLength/2);
	// scale it down to some reasonable value, say, the maximal dimension of the boxes
	mDisplay.scale(1/Math.max(sim.spaceHeight, Math.max(sim.spaceWidth, sim.spaceLength)));

	mDisplayFrame = mDisplay.createFrame();
	c.registerFrame(mDisplayFrame);
	mDisplayFrame.setVisible(true);
	}
	
    public void quit()
	{
	super.quit();

	if (mDisplayFrame!=null) mDisplayFrame.dispose();
	mDisplayFrame = null;  
	mDisplay = null;       
	}
	
	
    }
