package sim.app.virus;

import sim.portrayal.continuous.*;
import sim.engine.*;
import sim.display.*;
import javax.swing.*;
import java.awt.Color;


public class VirusInfectionDemoWithUI extends GUIState
    {

    public Display2D display;
    public JFrame displayFrame;

    ContinuousPortrayal2D vidPortrayal = new ContinuousPortrayal2D();

    public static void main(String[] args)
        {
        VirusInfectionDemoWithUI vid = new VirusInfectionDemoWithUI();
        Console c = new Console(vid);
        c.setVisible(true);
        }

    public VirusInfectionDemoWithUI() { super(new VirusInfectionDemo( System.currentTimeMillis())); }
    public VirusInfectionDemoWithUI(SimState state) { super(state); }

    public String getName() { return "Virus (Dis)Infection Demonstration!"; }
    
    public String getInfo()
	{
        VirusInfectionDemo vids = (VirusInfectionDemo) state;

        return
	    "<H2>Virus Infection Demonstration</H2>by Liviu Panait.<p>Parameters:" +
	    "<tr><td>Number of Innocent Agents</td><td>" + VirusInfectionDemo.NUM_HUMANS  + "</td></tr>" +
	    "<tr><td>Number of Good (Disinfecting) Agents</td><td>" + VirusInfectionDemo.NUM_GOODS  + "</td></tr>" +
	    "<tr><td>Number of Evil (Infecting) Agents</td><td>" + VirusInfectionDemo.NUM_EVILS  + "</td></tr>" +
	    "</table>";
	}
    
    public void start()
	{
        super.start();
        setupPortrayals();
	}

    public void load(SimState state)
        {
        super.load(state);
        setupPortrayals();
        }
        
    public void setupPortrayals()
        {
        // tell the portrayals what to portray and how to portray them
        vidPortrayal.setField(((VirusInfectionDemo)state).environment);
            
        // reschedule the displayer
        display.reset();
        display.setBackdrop(Color.white);
                
        // redraw the display
        display.repaint();
        }

    public void init(Controller c)
        {
        super.init(c);

        // make the displayer
        display = new Display2D(800,600,this,1);

        displayFrame = display.createFrame();
        displayFrame.setTitle("Virus (Dis)Infection Demonstration Display");
        c.registerFrame(displayFrame);   // register the frame so it appears in the "Display" list
        displayFrame.setVisible(true);
        display.attach( vidPortrayal, "Agents" );
        }
        
    public void quit()
        {
        super.quit();
        
        if (displayFrame!=null) displayFrame.dispose();
        displayFrame = null;
        display = null;
        }

    }
