package sim.field.network;

/**
   An Edge stores a relationship between two objects in a NetworkField.  Edges are directed: one
   object is a "from" object and one object is a "to" object.  Edges also hold an "info" object, which
   is an arbitrary object that you specify on your own.  An info object can be used to hold the edge
   weight, an edge label, or whatever you like.  Edges are "semi-mutable": you can change the info
   object at any time, but you may not change the to or from objects once the Edge has been constructed.
    
   <p>An Edge may be added to at most one NetworkField.  You must remove it from that field before you
   can add it to a new NetworkField.  The Edge's field is known as its <i>owner</i>.
*/
public class Edge implements java.io.Serializable
    {
    // to prevent edges from breaking fields by being stored in two different fields.
    // if null, then no owner -- the Edge is free to be added to a field.
    NetworkField owner;

    // purposely package-level protection: you shouldn't play with these.
    /** The node from where the edge leaves */
    Object from;

    // purposely package-level protection: you shouldn't play with these.
    /** The node where the edge enters */
    Object to;

    /** Other information (maybe cost) associated with the edge */
    public Object info;

    // The index in the bag of from links in the from node. Used for
    // faster remove operations
    int indexFrom;

    // The index in the bag of in links in the in node Used for
    // faster remove operations
    int indexTo;
    
    /** Returns the "from" object. */
    public Object from() { return from; }
    /** Returns the "to" object. */
    public Object to() { return to; }
    /** Returns the "owner" field. */
    public NetworkField owner() { return owner; }
    
    public Edge( final Edge e )
	{
        this( e.from, e.to, e.info, e.indexFrom, e.indexTo );
	}

    public Edge( final Object from, final Object to, final Object info )
	{
        this( from, to, info, -1, -1 );
	}

    Edge( final Object from, final Object to, final Object info, final int indexFrom, final int indexTo )
	{
        this.from = from;
        this.to = to;
        this.info = info;
        this.indexFrom = indexFrom;
        this.indexFrom = indexTo;
	}
    }
