package sim.portrayal.network;

import sim.field.grid.*;
import sim.field.continuous.*;
import sim.field.network.*;
import sim.util.*;

/** A wrapper used by NetworkPortrayal2D to hold a NetworkField and EITHER a Continuous2D OR a SparseGrid2D.
    The Continuous2D/SparseGrid2D specifies the spatial location of the nodes; the NetworkField specifies the
    edges connecting those nodes. */

public class SpatialNetwork2D
    {
    public Continuous2D field;
    public SparseGrid2D grid;
    public NetworkField network;

    public SpatialNetwork2D( final Continuous2D field, final NetworkField network )
	{
        this.field = field;
        this.network = network;
	}
    
    public SpatialNetwork2D( final SparseGrid2D grid, final NetworkField network )
	{
        this.grid = grid;
        this.network = network;
	}

    public Double2D getObjectLocation(Object node)
        {
        if (field!=null) return field.getObjectLocation(node);
        else return new Double2D(grid.getObjectLocation(node));
        }

    public double getWidth()
        {
        if (field!=null) return field.getWidth();
        else return grid.getWidth();
        }
        
    public double getHeight()
        {
        if (field!=null) return field.getHeight();
        else return grid.getHeight();
        }
    }
