package sim.portrayal3d.continuous;

import javax.vecmath.*;
import sim.portrayal.*;
import sim.portrayal3d.*;
import sim.util.*;
import sim.field.continuous.*;

import com.sun.j3d.utils.picking.*;

/**
 * Portrays both Continuous2D and Continuous3D fields. 
 * 2D fields are spread through the XY plane and are presumed to have Z=0.
 *
 * @author Gabriel Balan
 */
public class ContinuousPortrayal3D extends SparseFieldPortrayal3D
    {
    /**
     * @see sim.portrayal.SparseFieldPortrayal3D#getLocationOfObjectAsVector3d(Object)
     */
    public Vector3d getLocationOfObjectAsVector3d(Object obj, Vector3d putInHere)
	{
	if (field instanceof Continuous2D)
	    {
	    Double2D locationD2d = ((Continuous2D)field).getObjectLocation(obj);
	    putInHere.x = locationD2d.x;
	    putInHere.y = locationD2d.y;
	    putInHere.z = 0;
	    }
	else
	    {
	    Double3D locationD3d = ((Continuous3D)field).getObjectLocation(obj);
	    putInHere.x = locationD3d.x;
	    putInHere.y = locationD3d.y;
	    putInHere.z = locationD3d.z;
	    }
	return putInHere;
	}

    public void setField(Object field)
	{
	if (field instanceof Continuous3D) this.field = (Continuous3D) field;
        else if (field instanceof Continuous2D) this.field = (Continuous2D) field;
	else throw new RuntimeException("Invalid field for ContinuousPortrayal3D3D: " + field);
	}
            
    public LocationWrapper completedWrapper(LocationWrapper w, PickIntersection pi)
	{
	return new LocationWrapper( w.getObject(), null, this)  // don't care about location
	    {
	    public Object getLocation()
		{
		if(field instanceof Continuous3D)
		    return ((Continuous3D)field).getObjectLocation(object);
		else
		    return ((Continuous2D)field).getObjectLocation(object);
		}
                
	    public String getLocationName()
		{
		if(field instanceof Continuous3D)
		    return ((Continuous3D)field).getObjectLocation(object).toCoordinates();
		else
		    return ((Continuous2D)field).getObjectLocation(object).toCoordinates();
		}
	    };
	}	
    }
