package sim.portrayal3d.simple;

import com.sun.j3d.utils.geometry.*;
import sim.portrayal3d.*;
import sim.portrayal.*;
import javax.media.j3d.*;

/**
 * Portrays objects as a cube of the specified color or appearance (flat opaque white by default)
 * which fills the region from (-0.5*scale,-0.5*scale,-0.5*scale) to (0.5*scale,0.5*scale,0.5*scale).
 * Objects portrayed by this portrayal are selectable.
 */
public class CubePortrayal3D extends SimplePortrayal3D
    {
    public float scale = 1f;
    public Appearance appearance;
    public boolean generateNormals;
    public boolean generateTextureCoordinates;
	
    /** Constructs a CubePortrayal3D with a default (flat opaque white) appearance and a scale of 1.0. */
    public CubePortrayal3D()
        {
        this(1f);
        }
        
    /** Constructs a CubePortrayal3D with a default (flat opaque white) appearance and the given scale. */
    public CubePortrayal3D(float scale)
        {
        this(java.awt.Color.white,scale);
        }
        
    /** Constructs a CubePortrayal3D with a flat opaque appearance of the given color and a scale of 1.0. */
    public CubePortrayal3D(java.awt.Color color)
	{
        this(color,1f);
        }
        
    /** Constructs a CubePortrayal3D with a flat opaque appearance of the given color and the given scale. */
    public CubePortrayal3D(java.awt.Color color, float scale)
	{
        this(appearanceForColor(color),false,false,scale);
	}

    /** Constructs a CubePortrayal3D with the given (opaque) image and a scale of 1.0. */
    public CubePortrayal3D(java.awt.Image image)
	{
        this(image,1f);
	}

    /** Constructs a CubePortrayal3D with the given (opaque) image and scale. */
    public CubePortrayal3D(java.awt.Image image, float scale)
	{
        this(appearanceForImage(image,true),false,true,scale);
	}

    /** Constructs a CubePortrayal3D with the given appearance and scale, plus whether or not to generate normals or texture coordinates.  Without texture coordiantes, a texture will not be displayed */
    public CubePortrayal3D(Appearance appearance, boolean generateNormals, boolean generateTextureCoordinates, float scale)
	{
        this.generateNormals = generateNormals;
        this.generateTextureCoordinates = generateTextureCoordinates;
	this.appearance = appearance;  this.scale = scale;
	}

    public TransformGroup getModel(Object obj, TransformGroup j3dModel)
	{
	if(j3dModel==null)
	    {
	    j3dModel = new TransformGroup();
            
            // make a box
            Box box = new Box(scale/2,scale/2,scale/2,
			      Primitive.GEOMETRY_NOT_SHARED | 
			      (generateNormals ? Primitive.GENERATE_NORMALS : 0) | 
			      (generateTextureCoordinates ? Primitive.GENERATE_TEXTURE_COORDS : 0), appearance);
            
            // make all of its shapes pickable
            setPickableFlags(box.getShape(Box.BACK));
            setPickableFlags(box.getShape(Box.FRONT));
            setPickableFlags(box.getShape(Box.LEFT));
            setPickableFlags(box.getShape(Box.RIGHT));
            setPickableFlags(box.getShape(Box.TOP));
            setPickableFlags(box.getShape(Box.BOTTOM));
            
	    // build a LocationWrapper for the object
            LocationWrapper pickI = new LocationWrapper(obj, null, parentPortrayal);
            
            // Store the LocationWrapper in the user data each shape
            box.getShape(Box.BACK).setUserData(pickI);
            box.getShape(Box.FRONT).setUserData(pickI);
            box.getShape(Box.LEFT).setUserData(pickI);
            box.getShape(Box.RIGHT).setUserData(pickI);
            box.getShape(Box.TOP).setUserData(pickI);
            box.getShape(Box.BOTTOM).setUserData(pickI);

            j3dModel.addChild(box);
            }
	return j3dModel;
	}
    }
