package sim.app.flockers;
import sim.engine.*;
import sim.field.continuous.*;
import sim.util.*;
import ec.util.*;

public class Flocker implements Steppable, sim.portrayal.Oriented2D
    {
    public Flocker a;
    public Flocker b;
    public Double2D loc = new Double2D(0,0);
    public Double2D lastd = new Double2D(0,0);
    public Continuous2D flockers;
    
    public Object[] getNeighbors()
        {
        Bag b = flockers.getObjectsWithinDistance(loc, flockers.discretization, true);
        if (b==null) return new Object[0];
        else return b.objs;
        }
    
    public double orientation2D()
        {
        if (lastd.x == 0 && lastd.y == 0) return 0;
        return Math.atan2(lastd.y, lastd.x);
        }
    
    public Double2D momentum()
        {
        return lastd;
        }
        
    public Double2D consistency(Bag b, Bag locs, Continuous2D flockers)
        {
        if (b==null || b.numObjs == 0) return new Double2D(0,0);
        
        double x = 0; 
        double y= 0;
        int i =0;
        for(i=0;i<b.numObjs;i++)  if (!((Flocker)(b.objs[i])).dead)
            {
            Double2D l = (Double2D)(locs.objs[i]);
            double dx = flockers.tdx(loc.x,l.x);
            double dy = flockers.tdy(loc.y,l.y);
            double lensquared = dx*dx+dy*dy;
            if (lensquared <= flockers.discretization * flockers.discretization)
                {
                Double2D m = ((Flocker)b.objs[i]).momentum();
                x += m.x;
                y += m.y;
                }
            }
        x /= b.numObjs;
        y /= b.numObjs;
        return new Double2D(x,y);
        }
    
    public Double2D cohesion(Bag b, Bag locs, Continuous2D flockers)
        {
        if (b==null || b.numObjs == 0) return new Double2D(0,0);
        
        double x = 0; 
        double y= 0;
        int i =0;
        for(i=0;i<b.numObjs;i++) if (!((Flocker)(b.objs[i])).dead)
            {
            Double2D l = (Double2D)(locs.objs[i]);
            double dx = flockers.tdx(loc.x,l.x);
            double dy = flockers.tdy(loc.y,l.y);
            double lensquared = dx*dx+dy*dy;
            if (lensquared <= flockers.discretization * flockers.discretization)
                {
                x += dx;
                y += dy;
                }
            }
        x /= b.numObjs;
        y /= b.numObjs;
        return new Double2D(-x/10,-y/10);
        }
    
    public Double2D avoidance(Bag b, Bag locs, Continuous2D flockers)
        {
        if (b==null || b.numObjs == 0) return new Double2D(0,0);
        
        double x = 0;
        double y = 0;
        
        int i=0;
        int count = 0;
        for(i=0;i<b.numObjs;i++)
            {
            if (b.objs[i] != this)
                {
                count++;
                Double2D l = (Double2D)(locs.objs[i]);
                double dx = flockers.tdx(loc.x,l.x);
                double dy = flockers.tdy(loc.y,l.y);
                double lensquared = dx*dx+dy*dy;
                if (lensquared <= flockers.discretization * flockers.discretization)
                    {
                    x += dx/(lensquared*lensquared + 1);
                    y += dy/(lensquared*lensquared + 1);
                    }
                }
            }
        if (count>0)
            {
            x /= count;
            y /= count;
            }
        return new Double2D(400*x,400*y);
        }
        
    public Double2D randomness(MersenneTwisterFast r)
        {
        double x = r.nextDouble() * 2 - 1.0;
        double y = r.nextDouble() * 2 - 1.0;
        double l = Math.sqrt(x * x + y * y);
        return new Double2D(0.05*x/l,0.05*y/l);
        }
    
    public boolean dead = false;
    
    public void step(SimState state)
        {
        if (dead) return;
        
        final Flockers flock = (Flockers)state;
        loc = flock.flockers.getObjectLocation(this);
        
        Bag b = flockers.getObjectsWithinDistance(loc, flockers.discretization, true);
        Bag locs = new Bag(b.numObjs);
        for(int i=0;i<b.numObjs;i++)
            locs.add(flockers.getObjectLocation(b.objs[i]));
            
        Double2D avoid = avoidance(b,locs,flock.flockers);
        Double2D cohe = cohesion(b,locs,flock.flockers);
        Double2D rand = randomness(flock.random);
        Double2D cons = consistency(b,locs,flock.flockers);
        Double2D mome = momentum();

        double dx = flock.cohesion * cohe.x + flock.avoidance * avoid.x + flock.consistency* cons.x + flock.randomness * rand.x + flock.momentum * mome.x;
        double dy = flock.cohesion * cohe.y + flock.avoidance * avoid.y + flock.consistency* cons.y + flock.randomness * rand.y + flock.momentum * mome.y;
                
        // renormalize to the given step size
        double dis = Math.sqrt(dx*dx+dy*dy);
        if (dis>0)
            {
            dx = dx / dis * flock.jump;
            dy = dy / dis * flock.jump;
            }
        
        lastd = new Double2D(dx,dy);
        loc = new Double2D(flock.flockers.stx(loc.x + dx), flock.flockers.sty(loc.y + dy));
        flock.flockers.setObjectLocation(this, loc);
        }
 
    }
