package sim.app.lsystem;

public class ByteList implements java.io.Serializable
    {

    public byte[] b;
    public int length = 0;
    
    ByteList()
	{
        b = new byte[16];
	}
    
    ByteList(int size)
	{
        b = new byte[size];
	}
    
    ByteList(ByteList a)
	{
        b = new byte[a.b.length];
        System.arraycopy(a.b,0,b,0,a.length);
        length = a.length;
	}
    
    // assume only one addition at a time
    public void add(byte n)
	{
        // double if necessary
        if(length == b.length)
	    {
            byte[] b2 = new byte[length*2];
            System.arraycopy(b,0,b2,0,length);
            b = b2;
	    }
        
        b[length] = n;
        length++;
	}
    
    public void addAll(ByteList a)
	{
        byte[] b2 = b;
        if (a.length + length >= b.length)
	    {
            b2 = new byte[(length + b.length)*2];
            System.arraycopy(b,0,b2,0,length);
            b = b2;
	    }
        
        System.arraycopy(a.b,0,b2,length,a.length);
        length += a.length;
	}
    
    public void clear()
	{
        b = new byte[16];
        length = 0;
	}
    }
