package sim.app.tutorial3;
import sim.engine.*;
import sim.field.grid.*;
import sim.util.*;
import ec.util.*;

public class Tutorial3 extends SimState
    {
    public DoubleGrid2D trails;
    public SparseGrid2D particles;
    
    public int gridWidth = 100;
    public int gridHeight = 100;
    public int numParticles = 500;
    
    public Tutorial3(long seed)
        {
        super(new MersenneTwisterFast(seed), new Schedule(3));
        }

    public void start()
        {
        super.start();
        trails = new DoubleGrid2D(gridWidth, gridHeight);
        particles = new SparseGrid2D(gridWidth, gridHeight);
        
        Particle p;
        
        for(int i=0 ; i<numParticles ; i++)
            {
            p = new Particle(random.nextInt(3) - 1, random.nextInt(3) - 1);  // random direction
            schedule.scheduleRepeating(p);
            particles.setObjectLocation(p,
					new Int2D(random.nextInt(gridWidth),random.nextInt(gridHeight)));  // random location
            }
        
        // Schedule the decreaser
        Steppable decreaser = new Steppable()
            {
            public void step(SimState state)
                {
                // decrease the trails
                trails.multiply(0.9);
                }
            static final long serialVersionUID = 6330208160095250478L;
            };
            
        schedule.scheduleRepeating(Schedule.EPOCH,2,decreaser,1);
        }

    public static void main(String[] args)
        {
        Tutorial3 tutorial3 = null;
        
        // should we load from checkpoint?  I wrote this little chunk of code to
        // check for this to give you the general idea.
        
        for(int x=0;x<args.length-1;x++)  // "-checkpoint" can't be the last string
            if (args[x].equals("-checkpoint"))
                {
                SimState state = SimState.readFromCheckpoint(new java.io.File(args[x+1]));
                if (state == null)   // there was an error -- it got printed out to the screen, so just quit
                    System.exit(1);
                else if (!(state instanceof Tutorial3))  // uh oh, wrong simulation stored in the file!
                    {
                    System.out.println("Checkpoint contains some other simulation: " + state);
                    System.exit(1);
                    }
                else // we're ready to lock and load!  
                    tutorial3 = (Tutorial3)state;
                }
        
        // ...or should we start fresh?
        if (tutorial3==null)  // no checkpoint file requested
            {
            tutorial3 = new Tutorial3(System.currentTimeMillis());
            tutorial3.start();
            }
        
        long time;
        while((time = tutorial3.schedule.time()) < 5000)
            {
            if (time % 100 == 0) System.out.println(time);
            if (!tutorial3.schedule.step(tutorial3))
                break;

            // checkpoint
            if (time%500==0 && time!=0)
                {
                String s = "tutorial3." + time + ".checkpoint";
                System.out.println("Checkpointing to file: " + s);
                tutorial3.writeToCheckpoint(new java.io.File(s));
                }
            }
            
        tutorial3.finish();  // we don't use this, but it's good style
        }

    static final long serialVersionUID = 9115981605874680023L;    
    }
