package sim.app.tutorial6;
import sim.engine.*;
import sim.field.continuous.*;
import sim.util.*;
import ec.util.*;

public class Tutorial6 extends SimState
    {
    static final int PLUTO = 9;  // Furthest-out body
    public Continuous2D bodies;

    public Tutorial6(long seed)
        {
	super(new MersenneTwisterFast(seed), new Schedule(1));
        bodies = new Continuous2D(DISTANCE[PLUTO],DISTANCE[PLUTO],DISTANCE[PLUTO]);
        }

    // distance from sun in 10^5 km
    public static final double[] DISTANCE = new double[]
    {0, 579, 1082, 1496, 2279, 7786, 14335, 28725, 44951, 58700}; 

    // diameters in 10 km
    public static final double[] DIAMETER = new double[] 
    {139200.0, 487.9, 1210.4, 1275.6, 679.4, 14298.4, 12053.6, 5111.8, 4952.8, 239.0};
 
    // period in days 
    public static final double[] PERIOD = new double[] 
    {1 /* don't care :-) */, 88.0, 224.7, 365.2, 687.0, 4331, 10747, 30589, 59800, 90588 };

    public void start()
        {
        super.start();
        
        bodies = new Continuous2D(DISTANCE[PLUTO],DISTANCE[PLUTO],DISTANCE[PLUTO]);
        
        // make the bodies  -- stick them out the x axis, sweeping towards the y axis.
	for(int i=0; i<10;i++)
            {
            Body b = new Body((2*Math.PI*DISTANCE[i]) / PERIOD[i], DISTANCE[i]);
	    bodies.setObjectLocation(b, new Double2D(DISTANCE[i],0)); 
	    schedule.scheduleRepeating(b);
            }
        }

    public static void main(String[] args)
        {
        Tutorial6 tutorial6 = null;
        
        for(int x=0;x<args.length-1;x++)
            if (args[x].equals("-checkpoint"))
                {
                SimState state = SimState.readFromCheckpoint(new java.io.File(args[x+1]));
                if (state == null) System.exit(1);
                else if (!(state instanceof Tutorial6))
                    {
                    System.out.println("Checkpoint contains some other simulation: " + state);
                    System.exit(1);
                    }
                else tutorial6 = (Tutorial6)state;
                }
        
        if (tutorial6==null)
            {
            tutorial6 = new Tutorial6(System.currentTimeMillis());
            tutorial6.start();
            }
        
        long time;
        while((time = tutorial6.schedule.time()) < 10000)
            {
            if (time % 10 == 0) System.out.println(time);
            if (!tutorial6.schedule.step(tutorial6)) break;
            if (time%365==0 && time!=0)
                {
                String s = "tutorial6." + time + ".checkpoint";
                System.out.println("Checkpointing to file: " + s);
                tutorial6.writeToCheckpoint(new java.io.File(s));
                }
            }
        tutorial6.finish();
        }
    }
