package sim.app.woims3d;

import sim.portrayal3d.continuous.*;
import sim.portrayal3d.simple.*;
import sim.engine.*;
import sim.display.*;
import sim.display3d.*;

import javax.swing.*;

public class WoimsDemo3DWithUI extends GUIState
    {
    public Display3D display;
    public JFrame displayFrame;

    public String getName() { return "Woims Demonstration!"; }

    public String getInfo()  // we'll just assume it's HTML
	{
        WoimsDemo3D wd = (WoimsDemo3D) state;
 
	return "<H2>Woims Demonstration</H2>by Liviu Panait & Gabriel Balan.<p>Parameters:" +
	    "<tr><td>Number of Woims</td><td>" + WoimsDemo3D.NUM_WOIMS  + "</td></tr>" +
	    "</table>"; 
	}

    public static void main(String[] args)
        {
        WoimsDemo3DWithUI woims = new WoimsDemo3DWithUI(new WoimsDemo3D(System.currentTimeMillis()));
        Console c = new Console(woims);
        c.setVisible(true);
        }
    public WoimsDemo3DWithUI()
	{
    	this(new WoimsDemo3D(System.currentTimeMillis()));
        }

    ContinuousPortrayal3D p2;
    LightPortrayal3D light;
    WireFrameBoxPortrayal3D wireFrameP;

    public WoimsDemo3DWithUI(SimState state)
	{
        super(state);
        WoimsDemo3D wd = (WoimsDemo3D) state;
        p2 = new ContinuousPortrayal3D();
        p2.setField(wd.environment); 
        
        // build the light
        light= new LightPortrayal3D( java.awt.Color.white, new sim.util.Double3D(-2,-3,-1));

        // build the box
        wireFrameP = new WireFrameBoxPortrayal3D(-wd.EXTRA_SPACE,-wd.EXTRA_SPACE,-wd.EXTRA_SPACE,wd.environment.width + 2*wd.EXTRA_SPACE,wd.environment.height + 2*wd.EXTRA_SPACE,wd.environment.length + 2*wd.EXTRA_SPACE);
	}

        
    public void start()
	{
        super.start();  // clear out the schedule
        setupPortrayals();
	}
        
    public void load(SimState state)
	{
        super.load(state);  // clear out the schedule
        setupPortrayals();
	}
        
    public void setupPortrayals()
	{
        p2.setField(((WoimsDemo3D) state).environment);

        display.createSceneGraph();
        display.reset();
	}

    public void init(Controller c)
	{
        super.init(c);
        display = new Display3D(600,600,this,1);
        
        display.attach(p2,"Woims");
        display.attach(light, "SpotLight");
        display.attach(wireFrameP, "WireFrame");

        display.translate(-100,-100,-100);
        display.scale(1.0/200);

        displayFrame = display.createFrame();

        c.registerFrame(displayFrame);   // register the frame so it appears in the "Display" list
        displayFrame.setVisible(true);
	}

//    private void setDisplayPreferredSize()
//    {    
//		display.setPreferredSize(new Dimension(600,600));
//    } 
       
    public void quit()
	{
	super.quit();

        if (displayFrame!=null) displayFrame.dispose();
        displayFrame = null;  
        display = null;    
	}
    }
