package sim.app.hexabugs;
import sim.engine.*;
import sim.display.*;
import sim.portrayal.grid.*;
import java.awt.*;
import javax.swing.*;
import sim.util.gui.*;
import sim.portrayal.*;
import java.awt.event.*;

public class HexaBugsWithUI extends GUIState
    {
    public Display2D display;
    public JFrame displayFrame;

    HexaSparseGridPortrayal2D bugPortrayal = new HexaSparseGridPortrayal2D();

    // we have heat as EITHER hexagons OR rectangles.  The current portrayal is always
    // currentHeatPortrayal, which can be changed in the model inspector (see
    // getInspector() below)
    FastHexaValueGridPortrayal2D heatPortrayal= new FastHexaValueGridPortrayal2D("Heat");
    HexaValueGridPortrayal2D heatPortrayal2 = new HexaValueGridPortrayal2D("Heat");
    HexaValueGridPortrayal2D currentHeatPortrayal = heatPortrayal;

    public static void main(String[] args)
        {
        HexaBugsWithUI hexaBugs = new HexaBugsWithUI();
        Console c = new Console(hexaBugs);
        c.setVisible(true);
        }
    
    public HexaBugsWithUI() { super(new HexaBugs(System.currentTimeMillis())); }
    public HexaBugsWithUI(SimState state) { super(state); }
    
    public String getName() { return "Hexa Bugs"; }
    
    public Object getSimulationInspectedObject() { return state; }  // non-volatile
    
    /** We wrap an inspector with another one that lets us choose the portrayal being shown */
    public Inspector getInspector()
        {
        final Inspector originalInspector = super.getInspector();
        
        // our wrapper inspector
        Inspector newInspector = new Inspector()
            {
            public void updateInspector() { originalInspector.updateInspector(); }
            };
            
        newInspector.setLayout(new BorderLayout());
        newInspector.add(originalInspector,BorderLayout.CENTER);
        
        // create the pop-up menu
        final JComboBox menu = new JComboBox(new String[] {"Rectangles", "Hexagons"});
        menu.setSelectedIndex(0);
        menu.addActionListener(new ActionListener()
            {
            public void actionPerformed(ActionEvent e)
                {
                if (menu.getSelectedIndex() == 0)  // rectangles
                    currentHeatPortrayal = heatPortrayal;
                else currentHeatPortrayal = heatPortrayal2;
                
                // reattach the portrayals
                display.detatchAll();
                display.attach(currentHeatPortrayal,"Heat");
                display.attach(bugPortrayal,"Bugs");
                
                // redisplay
                if (display!=null) display.repaint();
                }
            });
        
        LabelledList list = new LabelledList();
        list.addLabelled("Display Grid Cells As",menu);
        newInspector.add(list,BorderLayout.NORTH);
        return newInspector;
        }

    public void start()
        {
        super.start();
        // set up our portrayals
        setupPortrayals();
        }
    
    public void load(SimState state)
        {
        super.load(state);
        // we now have new grids.  Set up the portrayals to reflect that
        setupPortrayals();
        }
        
    // This is called by start() and by load() because they both had this code
    // so I didn't have to type it twice :-)
    public void setupPortrayals()
        {
        // tell the portrayals what to portray and how to portray them
        ColorMap map = new sim.util.gui.SimpleColorMap(0,HexaBugs.MAX_HEAT,Color.black,Color.red);
        heatPortrayal.setField(((HexaBugs)state).valgrid);
        heatPortrayal.setMap(map);
        heatPortrayal2.setField(((HexaBugs)state).valgrid);
        heatPortrayal2.setMap(map);
        
        bugPortrayal.setField(((HexaBugs)state).buggrid);
        bugPortrayal.setPortrayalForAll(
            new sim.portrayal.simple.OvalPortrayal2D(Color.white));   // all the HexaBugs will be white ovals
            
        // reschedule the displayer
        display.reset();
                
        // redraw the display
        display.repaint();
        }
    
    /** The ratio of the width of a hexagon to its height: 1 / Sin(60 degrees), otherwise known as 2 / Sqrt(3) */
    public static final double HEXAGONAL_RATIO = 2/Math.sqrt(3);

    public void init(Controller c)
        {
        super.init(c);
        
        // Make the Display2D.  We'll have it display stuff later.
        
        // Horizontal hexagons are staggered.  This complicates computations.  Thus
        // if  you have a M x N grid scaled to SCALE, then
        // your height is (N + 0.5) * SCALE
        // and your width is ((M - 1) * (3/4) + 1) * HEXAGONAL_RATIO * SCALE
        
        // You might need to adjust by 1 or 2 pixels in each direction to get circles 
        // which usually come out as circles and not as ovals.
        
        final double scale = 4;
        final double m = 100;
        final double n = 100;
        final int height = (int) ( (n + 0.5) * scale );
        final int width = (int) ( ((m - 1) * 3.0 / 4.0 + 1) * HEXAGONAL_RATIO * scale );
        
        display = new Display2D(width, height, this, 1);
        displayFrame = display.createFrame();
        c.registerFrame(displayFrame);   // register the frame so it appears in the "Display" list
        displayFrame.setVisible(true);

        // attach the portrayals
        display.attach(currentHeatPortrayal,"Heat");
        display.attach(bugPortrayal,"Bugs");

        // specify the backdrop color  -- what gets painted behind the displays
        display.setBackdrop(Color.black);
        }
        
    public void quit()
        {
        super.quit();
        
        if (displayFrame!=null) displayFrame.dispose();
        displayFrame = null;  // let gc
        display = null;       // let gc
        }
    }
    
    
    
    
    
