package sim.app.keepaway;
import java.awt.*;
import sim.engine.*;
import sim.field.continuous.*;
import ec.util.*;
import sim.util.*;
import java.io.*;

public /*strictfp*/ class Keepaway extends SimState
    {
    /** @todo handle realocation of grids when these two are changed */
    public double xMin = 0;
    public double xMax = 100;
    public double yMin = 0;
    public double yMax = 100;
    
    public Continuous2D fieldEnvironment;
    

    /** Creates a Keepaway simulation with the given random number seed. */
    public Keepaway(long seed)
        {
        this(seed, 100, 100);
        }
        
    public Keepaway(long seed, int width, int height)
        {
        super(new MersenneTwisterFast(seed), new Schedule(2));
        xMax = width; yMax = height;
        createGrids();
        }

    void createGrids()
        {       
        fieldEnvironment = new Continuous2D(25, (xMax - xMin), (yMax - yMin));
        }
    
    /** Resets and starts a simulation */
    public void start()
        {
        super.start();  // clear out the schedule
        createGrids();

        Bot b;
        Vector2D loc = new Vector2D(0, 0);
        
        // bot 1-1  
        loc.x = random.nextDouble()*xMax;
        loc.y = random.nextDouble()*yMax;
        b = new Bot(loc.x, loc.y, Color.red);
        b.cap = 0.65;
        fieldEnvironment.setObjectLocation(b, new Double2D(loc.x, loc.y));
        schedule.scheduleRepeating(b);
        
        // bot 2-1   
        loc.x = random.nextDouble()*xMax;
        loc.y = random.nextDouble()*yMax;
        b = new Bot(loc.x, loc.y, Color.blue);
        b.cap = 0.5;
        fieldEnvironment.setObjectLocation(b, new Double2D(loc.x, loc.y));
        schedule.scheduleRepeating(b);
        
        
        // bot 2-2  
        loc.x = random.nextDouble()*xMax;
        loc.y = random.nextDouble()*yMax;
        b = new Bot(loc.x, loc.y, Color.blue);
        b.cap = 0.5;
        fieldEnvironment.setObjectLocation(b, new Double2D(loc.x, loc.y));
        schedule.scheduleRepeating(b);
        
        // bot 2-3  
        loc.x = random.nextDouble()*xMax;
        loc.y = random.nextDouble()*yMax;
        b = new Bot(loc.x, loc.y, Color.blue);
        b.cap = 0.5;
        fieldEnvironment.setObjectLocation(b, new Double2D(loc.x, loc.y));
        schedule.scheduleRepeating(b);
        
        // ball
        Ball ba;
        loc.x = random.nextDouble()*xMax;
        loc.y = random.nextDouble()*yMax;
        ba = new Ball(loc.x, loc.y);
        fieldEnvironment.setObjectLocation(ba, new Double2D(loc.x, loc.y));
        schedule.scheduleRepeating(ba);
        }
    
    
    public static void main(String[] args)
        {
        Keepaway keepaway = null;
        
        // should we load from checkpoint?  I wrote this little chunk of code to
        // check for this to give you the general idea.
        
        for(int x=0;x<args.length-1;x++)  // "-checkpoint" can't be the last string
            if (args[x].equals("-checkpoint"))
                {
                SimState state = SimState.readFromCheckpoint(new File(args[x+1]));
                if (state == null)   // there was an error -- it got printed out to the screen, so just quit
                    System.exit(1);
                else if (!(state instanceof Keepaway))  // uh oh, wrong simulation stored in the file!
                    {
                    System.out.println("Checkpoint contains some other simulation: " + state);
                    System.exit(1);
                    }
                else // we're ready to lock and load!  
                    keepaway = (Keepaway)state;
                }
        
        // ...or should we start fresh?
        if (keepaway==null)  // no checkpoint file requested
            {
            keepaway = new Keepaway(System.currentTimeMillis());  // make a new heatbugs.  Seed the RNG with the time
            keepaway.start();  // prep the bugs!
            System.out.println("Starting Keepaway.  Running for 5000 steps.");
            }
        
        long time;
        while((time = keepaway.schedule.time()) < 5000)
            {
            // step the schedule.  This is where everything happens.
            if (!keepaway.schedule.step(keepaway)) break;   // it won't happen that we end prematurely,
                                                            // but it's worth checking for!

            if (time%100==0 && time!=0) 
                System.out.println("Time Step " + time);
        
            // checkpoint
            if (time%500==0 && time!=0)
                {
                String s = "bb." + time + ".checkpoint";
                System.out.println("Checkpointing to file: " + s);
                keepaway.writeToCheckpoint(new File(s));
                }
            }
            
        keepaway.finish();  // we don't use this, but it's good style
        }
    }
    
    
    
    
    
