package sim.app.tutorial7;
import sim.engine.*;
import sim.field.grid.*;
import ec.util.*;

public class Tutorial7 extends SimState
    {
    public SparseGrid3D flies;
    public DoubleGrid2D xProjection;
    public DoubleGrid2D yProjection;
    public DoubleGrid2D zProjection;

    int width = 30;
    int height = 30;
    int length = 30;
    public void setWidth(int val) { if (val > 0) width = val; }
    public int getWidth() { return width; }
    public void setHeight(int val) { if (val > 0) height = val; }
    public int getHeight() { return height; }
    public void setLength(int val) { if (val > 0) length = val; }
    public int getLength() { return length; }

    public Tutorial7(long seed)
        {
        // two orders
        super(new MersenneTwisterFast(seed), new Schedule(2));
        }

    public void start()
        {
        super.start();
        
        flies = new SparseGrid3D(width,height,length);
        xProjection = new DoubleGrid2D(height,length);
        yProjection = new DoubleGrid2D(width,length);
        zProjection = new DoubleGrid2D(width,height);

        // schedule the zero-er at ordering 0
        schedule.scheduleRepeating(new Steppable()
            {
            public void step(SimState state)
                {
                xProjection.setTo(0);
                yProjection.setTo(0);
                zProjection.setTo(0);
                }
                
            // because I am an anonymous nested subclass (see Tutorial 3)...
            static final long serialVersionUID = -4596371762755892330L;
            });

        // make some random flies at ordering 1
        for(int i=0; i<100;i++)
            {
            Fly fly = new Fly();
            flies.setObjectLocation(fly, random.nextInt(width), random.nextInt(height), random.nextInt(length));
            schedule.scheduleRepeating(Schedule.EPOCH,1,fly,1);
            }
        
        }

    public static void main(String[] args)
        {
        Tutorial7 tutorial7 = null;
        
        // should we load from checkpoint?  I wrote this little chunk of code to
        // check for this to give you the general idea.
        
        for(int x=0;x<args.length-1;x++)  // "-checkpoint" can't be the last string
            if (args[x].equals("-checkpoint"))
                {
                SimState state = SimState.readFromCheckpoint(new java.io.File(args[x+1]));
                if (state == null)   // there was an error -- it got printed out to the screen, so just quit
                    System.exit(1);
                else if (!(state instanceof Tutorial7))  // uh oh, wrong simulation stored in the file!
                    {
                    System.out.println("Checkpoint contains some other simulation: " + state);
                    System.exit(1);
                    }
                else // we're ready to lock and load!  
                    tutorial7 = (Tutorial7)state;
                }
        
        // ...or should we start fresh?
        if (tutorial7==null)  // no checkpoint file requested
            {
            tutorial7 = new Tutorial7(System.currentTimeMillis());
            tutorial7.start();
            }
        
        long time;
        while((time = tutorial7.schedule.time()) < 10000)
            {
            if (time % 10 == 0) System.out.println(time);
            if (!tutorial7.schedule.step(tutorial7))
                break;

            // checkpoint
            if (time%1000==0 && time!=0)
                {
                String s = "tutorial7." + time + ".checkpoint";
                System.out.println("Checkpointing to file: " + s);
                tutorial7.writeToCheckpoint(new java.io.File(s));
                }
            }
            
        tutorial7.finish();  // we don't use this, but it's good style
        }

    // because I have an anonymous nested subclass (see Tutorial 3)...
    static final long serialVersionUID = -7776187839992045098L;
    }
