package sim.app.balls3d;
 
import sim.portrayal3d.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.geometry.Sphere;
 
public class NodePortrayal extends SimplePortrayal3D
    {
    double diameter;
    protected Color3f obstacleColor = new Color3f(0,255f/255,0); 
        
 
    public NodePortrayal( double diam )
        {
        this.diameter = diam;
        }
 
    public TransformGroup getModel(Object obj, TransformGroup j3dModel)
        {
        if(j3dModel==null)
            {
            j3dModel = new TransformGroup();
            Sphere s = new Sphere((float)diameter/2);
            Appearance appearance = new Appearance();
            appearance.setColoringAttributes(new ColoringAttributes(obstacleColor, ColoringAttributes.SHADE_GOURAUD));
            Material m= new Material();
            m.setAmbientColor(obstacleColor);
            m.setEmissiveColor(0f,0f,0f);
            m.setDiffuseColor(obstacleColor);
            m.setSpecularColor(1f,1f,1f);
            m.setShininess(128f);
            appearance.setMaterial(m);
 
            s.setAppearance(appearance);
            j3dModel.addChild(s);
            clearPickableFlags(j3dModel);
            }
        return j3dModel;
        }
    }
