package sim.app.networktest;

import sim.field.continuous.*;
import sim.field.network.*;
import sim.engine.*;
import sim.util.*;
import ec.util.*;
import java.io.*;

public /*strictfp*/ class NetworkTest extends SimState
    {
    public static final double XMIN = 0;
    public static final double XMAX = 800;
    public static final double YMIN = 0;
    public static final double YMAX = 600;

    public static final double DIAMETER = 8;

    public Continuous2D environment = null;
    public NetworkField network = null;

    /** Creates a NetworkTest simulation with the given random number seed. */
    public NetworkTest(long seed)
        {
        super(new MersenneTwisterFast(seed), new Schedule(2));
        }

    boolean acceptablePosition( final CustomNode node, final Double2D location )
        {
        if( location.x < DIAMETER/2 || location.x > (XMAX-XMIN)-DIAMETER/2 ||
            location.y < DIAMETER/2 || location.y > (YMAX-YMIN)-DIAMETER/2 )
            return false;
        return true;
        }

    public void start()
        {
        super.start();  // clear out the schedule

        environment = new Continuous2D(16.0, (XMAX-XMIN), (YMAX-YMIN) );
        network = new NetworkField();

        CustomNode[] nodes = new CustomNode[6];
        nodes[0] = new CustomNode( "node0",
                                   new Double2D( random.nextDouble()*(XMAX-XMIN-DIAMETER)+XMIN+DIAMETER/2,
                                                 random.nextDouble()*(YMAX-YMIN-DIAMETER)+YMIN+DIAMETER/2 ) );
        network.addNode(nodes[0]);
        nodes[1] = new CustomNode( "node1",
                                   new Double2D( random.nextDouble()*(XMAX-XMIN-DIAMETER)+XMIN+DIAMETER/2,
                                                 random.nextDouble()*(YMAX-YMIN-DIAMETER)+YMIN+DIAMETER/2 ) );
        network.addNode(nodes[1]);
        nodes[2] = new CustomNode( "node2",
                                   new Double2D( random.nextDouble()*(XMAX-XMIN-DIAMETER)+XMIN+DIAMETER/2,
                                                 random.nextDouble()*(YMAX-YMIN-DIAMETER)+YMIN+DIAMETER/2 ) );
        network.addNode(nodes[2]);
        nodes[3] = new CustomNode( "node3",
                                   new Double2D( random.nextDouble()*(XMAX-XMIN-DIAMETER)+XMIN+DIAMETER/2,
                                                 random.nextDouble()*(YMAX-YMIN-DIAMETER)+YMIN+DIAMETER/2 ) );
        network.addNode(nodes[3]);
        nodes[4] = new CustomNode( "node4",
                                   new Double2D( random.nextDouble()*(XMAX-XMIN-DIAMETER)+XMIN+DIAMETER/2,
                                                 random.nextDouble()*(YMAX-YMIN-DIAMETER)+YMIN+DIAMETER/2 ) );
        network.addNode(nodes[4]);
        nodes[5] = new CustomNode( "node5",
                                   new Double2D( random.nextDouble()*(XMAX-XMIN-DIAMETER)+XMIN+DIAMETER/2,
                                                 random.nextDouble()*(YMAX-YMIN-DIAMETER)+YMIN+DIAMETER/2 ) );
        network.addNode(nodes[5]);
        Edge e01 = new Edge( nodes[0], nodes[1], new EdgeInfo("0-1") );
        network.addEdge( e01 );
        Edge e12 = new Edge( nodes[1], nodes[2], new EdgeInfo("1-2") );
        network.addEdge( e12 );
        Edge e23 = new Edge( nodes[2], nodes[3], new EdgeInfo("2-3") );
        network.addEdge( e23 );
        Edge e34 = new Edge( nodes[3], nodes[4], new EdgeInfo("3-4") );
        network.addEdge( e34 );
        Edge e40 = new Edge( nodes[4], nodes[0], new EdgeInfo("4-0") );
        network.addEdge( e40 );
        Edge e05 = new Edge( nodes[0], nodes[5], new EdgeInfo("0-5") );
        network.addEdge( e05 );
        Edge e15 = new Edge( nodes[1], nodes[5], new EdgeInfo("1-5") );
        network.addEdge( e15 );
        Edge e25 = new Edge( nodes[2], nodes[5], new EdgeInfo("2-5") );
        network.addEdge( e25 );
        Edge e35 = new Edge( nodes[3], nodes[5], new EdgeInfo("3-5") );
        network.addEdge( e35 );
        Edge e45 = new Edge( nodes[4], nodes[5], new EdgeInfo("4-5") );
        network.addEdge( e45 );

        // Schedule the agents -- we could instead use a RandomSequence, which would be faster,
        // but this is a good test of the scheduler
        for(int x=0;x<6;x++)
            {
            environment.setObjectLocation(nodes[x],nodes[x].location);
            schedule.scheduleRepeating(nodes[x]);
            }
        }

    public static void main(String[] args)
        {
        NetworkTest vid = null;
        
        // should we load from checkpoint?  I wrote this little chunk of code to
        // check for this to give you the general idea.
        
        for(int x=0;x<args.length-1;x++)  // "-checkpoint" can't be the last string
            if (args[x].equals("-checkpoint"))
                {
                SimState state = SimState.readFromCheckpoint(new File(args[x+1]));
                if (state == null)   // there was an error -- it got printed out to the screen, so just quit
                    System.exit(1);
                else if (!(state instanceof NetworkTest))  // uh oh, wrong simulation stored in the file!
                    {
                    System.out.println("Checkpoint contains some other simulation: " + state);
                    System.exit(1);
                    }
                else // we're ready to lock and load!  
                    vid = (NetworkTest)state;
                }
        
        // ...or should we start fresh?
        if (vid==null)  // no checkpoint file requested
            {
            vid = new NetworkTest(System.currentTimeMillis());  // make a new vid.  Seed the RNG with the time
            vid.start();  // prep the bugs!
            System.out.println("Starting NetworkTest.  Running for 50000 steps.");
            }
        
        long time;
        while((time = vid.schedule.time()) < 50000)
            {
            // step the schedule.  This is where everything happens.
            if (!vid.schedule.step(vid)) break;   // it won't happen that we end prematurely,
            // but it's worth checking for!

            if (time%1000==0 && time!=0) 
                System.out.println("Time Step " + time);
        
            // checkpoint
            if (time%5000==0 && time!=0)
                {
                String s = "hb." + time + ".checkpoint";
                System.out.println("Checkpointing to file: " + s);
                vid.writeToCheckpoint(new File(s));
                }
            }
            
        vid.finish();  // we don't use this, but it's good style
        }
        
    }
