package sim.app.cto;
import sim.field.continuous.*;
import sim.engine.*;
import sim.util.*;
import ec.util.*;
import java.io.*;

public /*strictfp*/ class CooperativeObservation extends SimState
    {
    public static final double XMIN = 0;
    public static final double XMAX = 400;
    public static final double YMIN = 0;
    public static final double YMAX = 400;
    
    public static final double DIAMETER = 8;
    
    public static final int NUM_TARGETS = 40;
    public static final int NUM_AGENTS = 10;

    Double2D[] agentPos;
    Double2D[] targetPos;
    public Continuous2D environment = null;

    KMeansEngine kMeansEngine;

    /** Creates a CooperativeObservation simulation with the given random number seed. */
    public CooperativeObservation(long seed)
        {
        super(new MersenneTwisterFast(seed), new Schedule(2));
        }

    boolean conflict( final Object agent1, final Double2D a, final Object agent2, final Double2D b )
        {
        if( ( ( a.x > b.x && a.x < b.x+DIAMETER ) ||
              ( a.x+DIAMETER > b.x && a.x+DIAMETER < b.x+DIAMETER ) ) &&
            ( ( a.y > b.y && a.y < b.y+DIAMETER ) ||
              ( a.y+DIAMETER > b.y && a.y+DIAMETER < b.y+DIAMETER ) ) )
            {
            return true;
            }
        return false;
        }

    boolean acceptablePosition( final Object agent, final Double2D location )
        {
        if( location.x < DIAMETER/2 || location.x > (XMAX-XMIN)/*environment.getXSize()*/-DIAMETER/2 ||
            location.y < DIAMETER/2 || location.y > (YMAX-YMIN)/*environment.getYSize()*/-DIAMETER/2 )
            return false;
        Bag misteriousObjects = environment.getObjectsWithinDistance( location, /*Strict*/Math.max( 2*DIAMETER, 2*DIAMETER ) );
        if( misteriousObjects != null )
            {
            for( int i = 0 ; i < misteriousObjects.numObjs ; i++ )
                {
                if( misteriousObjects.objs[i] != null && misteriousObjects.objs[i] != agent )
                    {
                    Object ta = (CTOAgent)(misteriousObjects.objs[i]);
                    if( conflict( agent, location, ta, environment.getObjectLocation(ta) ) )
                        return false;
                    }
                }
            }
        return true;
        }

    public void start()
        {
        super.start();  // clear out the schedule

        agentPos = new Double2D[ NUM_AGENTS ];
        for( int i = 0 ; i < NUM_AGENTS ; i++ )
            agentPos[i] = new Double2D();

        targetPos = new Double2D[ NUM_TARGETS ];
        for( int i = 0 ; i < NUM_TARGETS ; i++ )
            targetPos[i] = new Double2D();

        kMeansEngine = new KMeansEngine( this );

        environment = new Continuous2D(8.0, XMAX-XMIN, YMAX-YMIN);

        // Schedule the agents -- we could instead use a RandomSequence, which would be faster,
        // but this is a good test of the scheduler
        for(int x=0;x<NUM_AGENTS+NUM_TARGETS;x++)
            {
            Double2D loc = null;
            Int2D pos = null;
            CTOAgent agent = null;
            int times = 0;
            do
                {
                loc = new Double2D( random.nextDouble()*(XMAX-XMIN-DIAMETER)+XMIN+DIAMETER/2,
                                    random.nextDouble()*(YMAX-YMIN-DIAMETER)+YMIN+DIAMETER/2 );
                if( x < NUM_AGENTS )
                    {
                    agent = new CTOAgent( loc, CTOAgent.AGENT, "Agent"+x );
                    }
                else
                    {
                    agent = new CTOAgent( loc, CTOAgent.TARGET, "Target"+(x-NUM_AGENTS) );
                    }
                times++;
                if( times == 1000 )
                    {
                    System.out.println( "Cannot place agents. Exiting...." );
                    System.exit(1);
                    }
                } while( !acceptablePosition( agent, loc ) );
            environment.setObjectLocation(agent,loc);
            schedule.scheduleRepeating(agent);
            }

        }

    public static void main(String[] args)
        {
        CooperativeObservation co = null;
        
        // should we load from checkpoint?  I wrote this little chunk of code to
        // check for this to give you the general idea.
        
        for(int x=0;x<args.length-1;x++)  // "-checkpoint" can't be the last string
            if (args[x].equals("-checkpoint"))
                {
                SimState state = SimState.readFromCheckpoint(new File(args[x+1]));
                if (state == null)   // there was an error -- it got printed out to the screen, so just quit
                    System.exit(1);
                else if (!(state instanceof CooperativeObservation))  // uh oh, wrong simulation stored in the file!
                    {
                    System.out.println("Checkpoint contains some other simulation: " + state);
                    System.exit(1);
                    }
                else // we're ready to lock and load!  
                    co = (CooperativeObservation)state;
                }
        
        // ...or should we start fresh?
        if (co==null)  // no checkpoint file requested
            {
            co = new CooperativeObservation(System.currentTimeMillis());  // make a new co.  Seed the RNG with the time
            co.start();  // prep the bugs!
            System.out.println("Starting Cooperative Observation.  Running for 50000 steps.");
            }
        
        long time;
        while((time = co.schedule.time()) < 50000)
            {
            // step the schedule.  This is where everything happens.
            if (!co.schedule.step(co)) break;   // it won't happen that we end prematurely,
            // but it's worth checking for!

            if (time%1000==0 && time!=0) 
                System.out.println("Time Step " + time);
        
            // checkpoint
            if (time%5000==0 && time!=0)
                {
                String s = "hb." + time + ".checkpoint";
                System.out.println("Checkpointing to file: " + s);
                co.writeToCheckpoint(new File(s));
                }
            }
            
        co.finish();  // we don't use this, but it's good style
        }

    }
