// Class Ball
package sim.app.keepaway;
import java.awt.*;
import sim.util.*;
import sim.engine.*;

public /*strictfp*/ class Ball extends Entity implements Steppable
    {
    // used to determine if the ball is stuck
    public Vector2D stillPos;                           // last position
    public double dt;                                   // delta time--how many steps it has been still

    public Ball( final double x, final double y)
        {
        super(x,y,1,Color.white);
        
        cap = 2.0;
        
        bump = new Vector2D(0,0);
        stillPos = new Vector2D(0,0);
        dt = 0;
        }
 
    public Vector2D getForces( final Keepaway keepaway)
        {
        Bag objs = keepaway.fieldEnvironment.getObjectsWithinDistance(new Double2D(loc.x, loc.y), 100);

        double dist = 0;

        Vector2D sumVector = new Vector2D(0,0);

        for(int x=0; x<objs.numObjs; x++)
            {
            if(objs.objs[x] != this)
                {              
                dist = ((Entity)objs.objs[x]).loc.getDistTo(loc);
                    
                if((((Entity)objs.objs[x]).radius + radius) > dist)  // collision!
                    {
                    if(objs.objs[x] instanceof Ball)
                        {
                        // ball
                        // actually this is not possible with current settings
                        }
                    else // if(objs.objs[x] instanceof Ball)
                        {
                        // bot
                        // and this is handled by the bots themselves
                        }
                    }
                }
            }
        
        // add bump vector
        sumVector = sumVector.add(bump);
        bump.x = 0;
        bump.y = 0;
        return sumVector;
        }
    
    public void step( final SimState state )
        {
        Keepaway keepaway = (Keepaway)state;
        
        // get force
        final Vector2D force = getForces(keepaway);
        
        // acceleration = f/m
        final Vector2D accel = new Vector2D(force.x/mass,force.y/mass);
        
        // hacked friction
        final Vector2D friction = new Vector2D(-0.025 * velocity.x, -0.025 * velocity.y);
        
        // v = v + a
        velocity = velocity.add(accel);
        velocity = velocity.add(friction);
        capVelocity();
        
        // L = L + v
        Vector2D newLoc = new Vector2D( loc.x + velocity.x, loc.y + velocity.y);
        
        // save old pos for stuck checking
        stillPos.x = loc.x;
        stillPos.y = loc.y;
        
        // is new location valid?
        if(isValidMove(keepaway, newLoc))
            {
            loc = newLoc;
            }
        
        // check if ball hasn't moved much
        if(stillPos.getDistTo(loc) < 0.1)
            dt++;
        else
            dt = 0;
        
        // might be stuck...  move to random location!
        if(dt > 100)
            {
            dt = 0;
            loc.x = keepaway.random.nextDouble()*keepaway.xMax;
            loc.y = keepaway.random.nextDouble()*keepaway.yMax;
            }
            
        
        keepaway.fieldEnvironment.setObjectLocation(this, new Double2D(loc.x, loc.y));
        }
    }
