package sim.app.particle;
import sim.engine.*;
import sim.display3d.*;
import sim.display.*;
import sim.portrayal3d.grid.*;
import sim.portrayal3d.simple.*;
import java.awt.*;
import javax.swing.*;
//import sim.util.gui.*; 

public class ParticleSimWithUI extends GUIState
    {
    public Display3D display;
    public JFrame displayFrame;

    SparseGridPortrayal3D particlesPortrayal = new SparseGridPortrayal3D();
    ValueGridPortrayal3D trailsPortrayal = new ValueGridPortrayal3D("Trails"); 
    WireFrameBoxPortrayal3D wireFramePortrayal; 
        

    public static void main(String[] args)
        {
        ParticleSimWithUI t = new ParticleSimWithUI();
        Console c = new Console(t);
        c.setVisible(true);
        }
    
    public ParticleSimWithUI() { super(new ParticleSim(System.currentTimeMillis())); }
    
    public ParticleSimWithUI(SimState state) { super(state); }
    
    public String getName() { return "Particle: Particles"; }
    
    public String getInfo()
        {
        return "<H2>Particle</H2><p>An odd little particle-interaction example.";
        }
    
    public void quit()
        {
        super.quit();
        
        if (displayFrame!=null) displayFrame.dispose();
        displayFrame = null;  // let gc
        display = null;       // let gc
        }

    public void start()
        {
        super.start();
        // set up our portrayals
        setupPortrayals();
        }
    
    public void load(SimState state)
        {
        super.load(state);
        setupPortrayals();
        }
        
    public void setupPortrayals()
        {
        particlesPortrayal.setField(((ParticleSim)state).particles);
        particlesPortrayal.setPortrayalForAll(new SpherePortrayal3D(Color.red)); 
        
        trailsPortrayal.setField(((ParticleSim)state).trails); 
        trailsPortrayal.setMap(new sim.util.gui.SimpleColorMap(0.0, 1.0, new Color(0,0,0,0), Color.black)); 

        // reschedule the displayer
        display.reset();
                
        // redraw the display
        display.createSceneGraph();
        }
    
    public void init(Controller c)
        {
        super.init(c);
        display = new Display3D(600,600,this,1); 

        wireFramePortrayal = new WireFrameBoxPortrayal3D(-0.5,-0.5,-0.5,ParticleSim.gridWidth, ParticleSim.gridHeight, ParticleSim.gridLength, Color.blue); 
        
        // attach the portrayals
        display.attach(wireFramePortrayal,"Wire Frame"); 
        display.attach(particlesPortrayal,"Particles");
        display.attach(trailsPortrayal, "Trails"); 

        display.translate(-ParticleSim.gridWidth/2, 
                          -ParticleSim.gridHeight/2, 
                          -ParticleSim.gridLength/2); 
        
        display.scale(1.0/ParticleSim.gridWidth); 

        display.setBackdrop(Color.white);
        displayFrame = display.createFrame();
        c.registerFrame(displayFrame);   // register the frame so it appears in the "Display" list
        displayFrame.setVisible(true);

        }
    }
    
    
    
    
    
