package sim.app.particles3d;

import sim.engine.*;
import sim.field.grid.*;
import sim.util.*;
import ec.util.*;

public class Particles3D extends SimState
    {
    static public int gridWidth = 30;
    static public int gridHeight = 30;
    static public int gridLength = 30; 

    public SparseGrid3D particles;
    public DoubleGrid3D trails = new DoubleGrid3D(gridWidth, gridHeight, gridLength); 
        
    public int numParticles = 20;
    
    public Particles3D(long seed)
        {
        super(new MersenneTwisterFast(seed), new Schedule(3));
        }

    public void start()
        {
        super.start();
        particles = new SparseGrid3D(gridWidth, gridHeight, gridLength);
        trails = new DoubleGrid3D(gridWidth, gridHeight, gridLength);
        
        Particle p;
        
        for(int i=0 ; i<numParticles ; i++)
            {
            p = new Particle(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1); 
            schedule.scheduleRepeating(p);
            particles.setObjectLocation(p, new Int3D(random.nextInt(gridWidth), random.nextInt(gridHeight), 
                                                     random.nextInt(gridLength))); 
            }
        
        // Schedule the decreaser
        Steppable decreaser = new Steppable()
            {
            public void step(SimState state)
                {
                trails.multiply(0.9f); 
                }
            static final long serialVersionUID = 6330208160095250478L;
            };
            
        schedule.scheduleRepeating(Schedule.EPOCH,2,decreaser,1);
        }

    public static void main(String[] args)
        {
        Particles3D particle = null;
        
        // should we load from checkpoint?  I wrote this little chunk of code to
        // check for this to give you the general idea.
        
        for(int x=0;x<args.length-1;x++)  // "-checkpoint" can't be the last string
            if (args[x].equals("-checkpoint"))
                {
                SimState state = SimState.readFromCheckpoint(new java.io.File(args[x+1]));
                if (state == null)   // there was an error -- it got printed out to the screen, so just quit
                    System.exit(1);
                else if (!(state instanceof Particles3D))  // uh oh, wrong simulation stored in the file!
                    {
                    System.out.println("Checkpoint contains some other simulation: " + state);
                    System.exit(1);
                    }
                else // we're ready to lock and load!  
                    particle = (Particles3D)state;
                }
        
        // ...or should we start fresh?
        if (particle==null)  // no checkpoint file requested
            {
            particle = new Particles3D(System.currentTimeMillis());
            particle.start();
            }
        
        long time;
        while((time = particle.schedule.time()) < 5000)
            {
            if (time % 100 == 0) System.out.println(time);
            if (!particle.schedule.step(particle))
                break;

            // checkpoint
            if (time%500==0 && time!=0)
                {
                String s = "particle." + time + ".checkpoint";
                System.out.println("Checkpointing to file: " + s);
                particle.writeToCheckpoint(new java.io.File(s));
                }
            }
            
        particle.finish();  // we don't use this, but it's good style
        }

    static final long serialVersionUID = 9115981605874680023L;    
    }
